#!/usr/bin/ruby
"""
simplest implementation of a searcher
"""

require 'HyperEstraier'

# open the database
db = HyperEstraier::Database.new()
db.open('casket', HyperEstraier::Database::DBREADER)

# create a search condition object
cond = HyperEstraier::Condition.new()

# set the search phrase to the search condition object
cond.set_phrase('somewhere')

# get the result of search
result = db.search(cond, 0)

# for each document in result
result.each {|id|
	# get the document object
	doc = db.get_doc(id, 0)

	# display attributes
	puts "URI:		#{doc.attr('@uri')}"
	puts "Title:	#{doc.attr('@title')}"

	# display the body text
	puts doc.cat_texts()
}

