#!/usr/bin/env perl
# simplest implementation of a searcher

use strict;
use Data::Dumper;

use HyperEstraier;

# open the database
my $db = HyperEstraier::Database->new();
$db->open('casket', $HyperEstraier::ESTDBREADER);

# create a search condition object
my $cond = HyperEstraier::Condition->new();

# set the search phrase to the search condition object
$cond->set_phrase('somewhere');

# get the result of search
my $result = $db->search($cond, 0);
$result->get(0);

# for each document in result
for my $i (0..$result->size-1) {
	my $id = $result->get($i);
	my $doc = $db->get_doc($id, 0);
	# display attributes
	printf "URI:	%s\n", $doc->attr('@uri');
	printf "Title:	%s\n", $doc->attr('@title');

	# display the body text
	print $doc->cat_texts(), "\n";
}
