#!/usr/bin/env python
"""
the simplest implementation of a gatherer
"""

import HyperEstraier

# open the database
db = HyperEstraier.Database()
db.open('casket', HyperEstraier.Database.DBWRITER | HyperEstraier.Database.DBCREAT)

# create a document object 
doc = HyperEstraier.Document()

# add attributes to the document object 
doc.add_attr('@uri', "http://estraier.gov/example001.txt")
doc.add_attr("@title", "Over the Rainbow")

# add the body text to the document object 
doc.add_text("Somewhere over the rainbow.  Way up high.")
doc.add_text("There's a land that I heard of once in a lullaby.")

# register the document object to the database
db.put_doc(doc, HyperEstraier.Database.PDCLEAN)
