import birdbath.*;
import condor.*;
import java.rmi.*;

import birdbath.Transaction;

public class SubmitRemoveTest4
extends AbstractScheddTestCase
{
    // Transaction that removes a job it didn't submit
    protected void runTest()
    throws Throwable
    {
        Transaction transaction1 = schedd.createTransaction();
        transaction1.begin(10);
        int cluster = transaction1.createCluster();
        int job = transaction1.createJob(cluster);
        transaction1.submit(cluster,
                            job,
                            "matt",
                            UniverseType.VANILLA,
                            "/bin/true",
                            null,
                            "FALSE",
                            null,
                            null);
        transaction1.commit();

        CondorScheddPortType port = schedd.getPort();
        Status status = port.closeSpool(null, cluster, job);
        assertTrue("CloseSpool failed", status.getCode().equals(StatusCode.SUCCESS));
        status = port.removeJob(null, cluster, job, "I can 4", false);
        assertTrue("RemoveJob failed", status.getCode().equals(StatusCode.SUCCESS));

        try
        {
	    int job_status;
	    job_status = Integer.valueOf(new ClassAd(schedd.getJobAd(cluster, job)).get("JobStatus")).intValue();
	    if( job_status != 3 ) {
		fail("Remove didn't work");
	    }
        }
        catch (RemoteException exception)
        {
            // There was no job
        }
    }

    private static void check(Status status, String message)
    {
        assertTrue(message, status.getCode().equals(StatusCode.SUCCESS));
    }
}

