import birdbath.Transaction;
import condor.ClassAdStructAttr;
import condor.FileInfo;
import condor.UniverseType;

public class ScheddTestCase3
	extends AbstractScheddTestCase
{
	protected void runTest()
		throws Throwable
	{
		ClassAdStructAttr attributeWithNullType = new ClassAdStructAttr();
		attributeWithNullType.setName("a");
		attributeWithNullType.setValue("a");

		ClassAdStructAttr attributeWithNullName = new ClassAdStructAttr();
		attributeWithNullName.setValue("b");

		ClassAdStructAttr attributeWithNullEverything = new ClassAdStructAttr();

		ClassAdStructAttr[] extraAttributes =
		{
			attributeWithNullType,
			attributeWithNullName,
			attributeWithNullEverything
		};

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		int cluster;
		int job;

		try
		{
			cluster = transaction.createCluster();
			job = transaction.createJob(cluster);

			transaction.submit(cluster,
							   job,
							   null,
							   UniverseType.VANILLA,
							   "/bin/true",
							   null,
							   "OpSys != \"WINNT50\"",
							   extraAttributes,
							   null);
		}
		finally
		{
			transaction.commit();
		}

		transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			transaction.removeJob(cluster, job, "Test completed.");
		}
		finally
		{
			transaction.commit();
		}
	}
}
