module Data.Monoid.HT (cycle, (<>), ) where

import Data.Monoid (Monoid, mappend, )
import Data.Function (fix, )

import Prelude ()


{- |
Generalization of 'Data.List.cycle' to any monoid.
-}
cycle :: Monoid m => m -> m
cycle x =
   fix (mappend x)


infixr 6 <>

{- |
Infix synonym for 'mappend.
-}
(<>) :: Monoid m => m -> m -> m
(<>) = mappend
