{
{-# OPTIONS -funbox-strict-fields #-}

--------------------------------------------------------------------
-- |
-- Module    : Text.CSV.Lex
-- Copyright : (c) Galois, Inc. 2008
-- License   : All rights reserved
--
-- Maintainer: Don Stewart <dons@galois.com>
-- Stability : provisional
-- Portability:
--
--------------------------------------------------------------------
--
-- Efficiently lex CSV files.
--

module Text.CSV.ByteString.Lex ( lexCSV, CSVToken(..)) where

import qualified Data.ByteString as S
import Data.ByteString.Internal
import qualified Data.ByteString.Unsafe as S

import Foreign
import Foreign.C.Types
import Foreign.C.String

}

%wrapper "strict-bytestring"

lex :-

\,                    {\_ -> Comma }
\n                    {\_ -> Newline }
\r\n                  {\_ -> Newline }
[^\,\n\r]+            {Item}

{

-- | Efficiently lex CSV data from a bytestring
lexCSV :: S.ByteString -> [CSVToken]
lexCSV = alexScanTokens

data CSVToken = Comma
              | Newline
              | Item {-# UNPACK #-} !S.ByteString
              deriving (Eq, Show)

}

