package org.hibernate.envers.test.integration.merge;

import javax.persistence.Entity;
import javax.persistence.Id;

import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;

/**
 * @author Lukasz Antoniak (lukasz dot antoniak at gmail dot com)
 */
@Entity
@Audited
@AuditTable("GIVENIDSTRENTITY_AUD")
public class GivenIdStrEntity {
    @Id
    private Integer id;

    private String data;

    public GivenIdStrEntity() {
    }

    public GivenIdStrEntity(Integer id, String data) {
        this.id = id;
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GivenIdStrEntity)) return false;

        GivenIdStrEntity that = (GivenIdStrEntity) o;

        if (data != null ? !data.equals(that.data) : that.data != null) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GivenIdStrEntity(id = " + id + ", data = " + data + ")";
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
}
