/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2011, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.test.generatedkeys.seqidentity;

import org.junit.Test;

import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.testing.RequiresDialect;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;

import static org.junit.Assert.assertNotNull;
/**
 * @author Steve Ebersole
 */
@RequiresDialect( Oracle9iDialect.class )
public class SequenceIdentityTest extends BaseCoreFunctionalTestCase {
	public void configure(Configuration cfg) {
		//this test makes no sense w/o the following property enabled
		//note : this property is set to false by default in Oracle9iDialect
		//but if this property is set to false, then the AssertionFailure will
		//be thrown by {@link org.hibernate.engine.jdbc.internal.StatementPreparerImpl.checkAutoGeneratedKeysSupportEnabled()}
		//so let just change this here and this should be invested deeper.
		cfg.setProperty( Environment.USE_GET_GENERATED_KEYS, "true" );
	}

	public String[] getMappings() {
		return new String[] { "generatedkeys/seqidentity/MyEntity.hbm.xml" };
	}

	@Test
	public void testSequenceIdentityGenerator() {
		Session session = openSession();
		session.beginTransaction();

		MyEntity e = new MyEntity( "entity-1" );
		session.save( e );

		// this insert should happen immediately!
		assertNotNull( "id not generated through forced insertion", e.getId() );

		session.delete( e );
		session.getTransaction().commit();
		session.close();
	}
}
