/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

class ConnectionPoolDefinition
implements ConnectionPoolDefinitionIF {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ConnectionPoolDefinition == null ? (class$org$logicalcobwebs$proxool$ConnectionPoolDefinition = ConnectionPoolDefinition.class$("org.logicalcobwebs.proxool.ConnectionPoolDefinition")) : class$org$logicalcobwebs$proxool$ConnectionPoolDefinition);
    private Log poolLog = LOG;
    private String alias;
    private String jndiName;
    private String initialContextFactory;
    private String providerUrl;
    private String securityAuthentication;
    private String securityPrincipal;
    private String securityCredentials;
    private Properties delegateProperties = new Properties();
    private Properties completeInfo = new Properties();
    private Properties changedInfo = new Properties();
    private boolean connectionPropertiesChanged;
    private String url;
    private String completeUrl;
    private String driver;
    private int maximumConnectionLifetime;
    private int prototypeCount;
    private int minimumConnectionCount;
    private int maximumConnectionCount;
    private int houseKeepingSleepTime;
    private int simultaneousBuildThrottle;
    private int recentlyStartedThreshold;
    private int overloadWithoutRefusalLifetime;
    private int maximumActiveTime;
    private boolean verbose;
    private boolean trace;
    private String statistics;
    private String statisticsLogLevel;
    private Set fatalSqlExceptions = new HashSet();
    private String fatalSqlExceptionsAsString;
    private String fatalSqlExceptionWrapper = null;
    private String houseKeepingTestSql;
    private boolean testBeforeUse;
    private boolean testAfterUse;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ConnectionPoolDefinition;

    public ConnectionPoolDefinition() {
    }

    protected ConnectionPoolDefinition(String url, Properties info, boolean explicitRegister) throws ProxoolException {
        this.alias = ProxoolFacade.getAlias(url);
        this.poolLog = LogFactory.getLog("org.logicalcobwebs.proxool." + this.alias);
        this.reset();
        this.doChange(url, info, false, !explicitRegister);
    }

    protected void update(String url, Properties info) throws ProxoolException {
        this.changedInfo.clear();
        this.connectionPropertiesChanged = false;
        this.poolLog.debug("Updating definition");
        this.doChange(url, info, false, false);
        if (this.connectionPropertiesChanged) {
            this.poolLog.info("Mercifully killing all current connections because of definition changes");
            ProxoolFacade.killAllConnections(this.alias, "of definition changes", true);
        }
    }

    protected void redefine(String url, Properties info) throws ProxoolException {
        this.reset();
        this.changedInfo.clear();
        this.connectionPropertiesChanged = false;
        this.poolLog.debug("Redefining definition");
        this.doChange(url, info, false, false);
        if (this.getUrl() == null || this.getDriver() == null) {
            throw new ProxoolException("The URL is not defined properly: " + this.getCompleteUrl());
        }
        if (this.connectionPropertiesChanged) {
            LOG.info("Mercifully killing all current connections because of definition changes");
            ProxoolFacade.killAllConnections(this.alias, "definition has changed", true);
        }
    }

    private boolean doChange(String url, Properties info, boolean pretend, boolean implicitRegister) throws ProxoolException {
        boolean changed = false;
        try {
            int endOfPrefix = url.indexOf(58);
            int endOfDriver = url.indexOf(58, endOfPrefix + 1);
            if (endOfPrefix > -1 && endOfDriver > -1) {
                String driver = url.substring(endOfPrefix + 1, endOfDriver);
                if (ConnectionPoolDefinition.isChanged(this.getDriver(), driver)) {
                    changed = true;
                    if (!pretend) {
                        this.logChange(true, "proxool.driver", driver);
                        this.setDriver(driver);
                    }
                }
                String delegateUrl = url.substring(endOfDriver + 1);
                if (ConnectionPoolDefinition.isChanged(this.getUrl(), delegateUrl)) {
                    changed = true;
                    if (!pretend) {
                        this.logChange(true, "proxool.url", delegateUrl);
                        this.setUrl(delegateUrl);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error("Invalid URL: '" + url + "'", e);
            throw new ProxoolException("Invalid URL: '" + url + "'");
        }
        if (!pretend) {
            this.setCompleteUrl(url);
        }
        if (info != null) {
            Iterator<Object> i = info.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = info.getProperty(key);
                changed |= this.setAnyProperty(key, value, pretend);
                if (pretend) continue;
                this.completeInfo.setProperty(key, value);
            }
        }
        if (!pretend) {
            ProxoolFacade.definitionUpdated(this.getAlias(), this, this.completeInfo, this.changedInfo);
        }
        if ((this.getDriver() == null || this.getUrl() == null) && implicitRegister) {
            throw new ProxoolException("Attempt to refer to a unregistered pool by its alias '" + this.getAlias() + "'");
        }
        return changed;
    }

    private void logChange(boolean proxoolProperty, String key, String value) {
        if (this.poolLog.isDebugEnabled()) {
            String displayValue = value;
            if (key.toLowerCase().indexOf("password") > -1) {
                displayValue = "********";
            }
            this.poolLog.debug((proxoolProperty ? "Recognised proxool property: " : "Delegating property to driver: ") + key + "=" + displayValue);
        }
    }

    private boolean setAnyProperty(String key, String value, boolean pretend) throws ProxoolException {
        boolean proxoolProperty = true;
        boolean changed = false;
        changed = changed || this.setHouseKeeperProperty(key, value, pretend);
        changed = changed || this.setLoggingProperty(key, value, pretend);
        boolean bl = changed = changed || this.setJndiProperty(key, value, pretend);
        if (key.equals("user")) {
            proxoolProperty = false;
            if (ConnectionPoolDefinition.isChanged(this.getUser(), value)) {
                changed = true;
                if (!pretend) {
                    this.setUser(value);
                }
            }
        } else if (key.equals("password")) {
            proxoolProperty = false;
            if (ConnectionPoolDefinition.isChanged(this.getPassword(), value)) {
                changed = true;
                if (!pretend) {
                    this.setPassword(value);
                }
            }
        } else if (key.equals("proxool.driver")) {
            if (ConnectionPoolDefinition.isChanged(this.getDriver(), value)) {
                changed = true;
                if (!pretend) {
                    this.setDriver(value);
                }
            }
        } else if (key.equals("proxool.url")) {
            if (ConnectionPoolDefinition.isChanged(this.getUrl(), value)) {
                changed = true;
                if (!pretend) {
                    this.setUrl(value);
                }
            }
        } else if (key.equals("proxool.maximum-connection-count")) {
            if (this.getMaximumConnectionCount() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setMaximumConnectionCount(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.maximum-connection-lifetime")) {
            if (this.getMaximumConnectionLifetime() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setMaximumConnectionLifetime(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.maximum-new-connections")) {
            this.poolLog.warn("Use of proxool.maximum-new-connections is deprecated. Use more descriptive proxool.simultaneous-build-throttle instead.");
            if (this.getSimultaneousBuildThrottle() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setSimultaneousBuildThrottle(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.simultaneous-build-throttle")) {
            if (this.getSimultaneousBuildThrottle() != this.getInt(key, value)) {
                changed = true;
                this.setSimultaneousBuildThrottle(this.getInt(key, value));
            }
        } else if (key.equals("proxool.minimum-connection-count")) {
            if (this.getMinimumConnectionCount() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setMinimumConnectionCount(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.prototype-count")) {
            if (this.getPrototypeCount() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setPrototypeCount(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.recently-started-threshold")) {
            if (this.getRecentlyStartedThreshold() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setRecentlyStartedThreshold(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.overload-without-refusal-lifetime")) {
            if (this.getOverloadWithoutRefusalLifetime() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setOverloadWithoutRefusalLifetime(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.maximum-active-time")) {
            if (this.getMaximumActiveTime() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setMaximumActiveTime(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.fatal-sql-exception")) {
            if (ConnectionPoolDefinition.isChanged(this.fatalSqlExceptionsAsString, value)) {
                changed = true;
                if (!pretend) {
                    this.setFatalSqlExceptionsAsString(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.fatal-sql-exception-wrapper-class")) {
            if (ConnectionPoolDefinition.isChanged(this.fatalSqlExceptionWrapper, value)) {
                changed = true;
                if (!pretend) {
                    this.setFatalSqlExceptionWrapper(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.statistics")) {
            if (ConnectionPoolDefinition.isChanged(this.getStatistics(), value)) {
                changed = true;
                if (!pretend) {
                    this.setStatistics(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.statistics-log-level") && ConnectionPoolDefinition.isChanged(this.getStatisticsLogLevel(), value)) {
            changed = true;
            if (!pretend) {
                this.setStatisticsLogLevel(value.length() > 0 ? value : null);
            }
        }
        if (!key.startsWith("proxool.")) {
            if (ConnectionPoolDefinition.isChanged(this.getDelegateProperty(key), value)) {
                changed = true;
                if (!pretend) {
                    this.setDelegateProperty(key, value);
                }
            }
            proxoolProperty = false;
        }
        if (changed && !pretend) {
            this.logChange(proxoolProperty, key, value);
            this.changedInfo.setProperty(key, value);
        }
        return changed;
    }

    private boolean setLoggingProperty(String key, String value, boolean pretend) {
        boolean changed = false;
        if (key.equals("proxool.debug-level")) {
            if (value != null && value.equals("1")) {
                this.poolLog.warn("Use of proxool.debug-level=1 is deprecated. Use proxool.verbose=true instead.");
                if (!this.isVerbose()) {
                    changed = true;
                    if (!pretend) {
                        this.setVerbose(true);
                    }
                }
            } else {
                this.poolLog.warn("Use of proxool.debug-level=0 is deprecated. Use proxool.verbose=false instead.");
                if (this.isVerbose()) {
                    changed = true;
                    if (!pretend) {
                        this.setVerbose(false);
                    }
                }
            }
        } else if (key.equals("proxool.verbose")) {
            boolean valueAsBoolean = Boolean.valueOf(value);
            if (this.isVerbose() != valueAsBoolean) {
                changed = true;
                if (!pretend) {
                    this.setVerbose(valueAsBoolean);
                }
            }
        } else if (key.equals("proxool.trace")) {
            boolean valueAsBoolean = Boolean.valueOf(value);
            if (this.isTrace() != valueAsBoolean) {
                changed = true;
                if (!pretend) {
                    this.setTrace(valueAsBoolean);
                }
            }
        }
        return changed;
    }

    private boolean setHouseKeeperProperty(String key, String value, boolean pretend) throws ProxoolException {
        boolean changed = false;
        if (key.equals("proxool.house-keeping-sleep-time")) {
            if (this.getHouseKeepingSleepTime() != this.getInt(key, value)) {
                changed = true;
                if (!pretend) {
                    this.setHouseKeepingSleepTime(this.getInt(key, value));
                }
            }
        } else if (key.equals("proxool.house-keeping-test-sql")) {
            if (ConnectionPoolDefinition.isChanged(this.getHouseKeepingTestSql(), value)) {
                changed = true;
                if (!pretend) {
                    this.setHouseKeepingTestSql(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.test-before-use")) {
            boolean valueAsBoolean = Boolean.valueOf(value);
            if (this.isTestBeforeUse() != valueAsBoolean) {
                changed = true;
                if (!pretend) {
                    this.setTestBeforeUse(valueAsBoolean);
                }
            }
        } else if (key.equals("proxool.test-after-use")) {
            boolean valueAsBoolean = Boolean.valueOf(value);
            if (this.isTestAfterUse() != valueAsBoolean) {
                changed = true;
                if (!pretend) {
                    this.setTestAfterUse(valueAsBoolean);
                }
            }
        }
        return changed;
    }

    private boolean setJndiProperty(String key, String value, boolean pretend) {
        boolean changed = false;
        if (key.equals("proxool.jndi-name")) {
            if (ConnectionPoolDefinition.isChanged(this.getJndiName(), value)) {
                changed = true;
                if (!pretend) {
                    this.setJndiName(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.initial-context-factory")) {
            if (ConnectionPoolDefinition.isChanged(this.getInitialContextFactory(), value)) {
                changed = true;
                if (!pretend) {
                    this.setInitialContextFactory(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.provider-url")) {
            if (ConnectionPoolDefinition.isChanged(this.getProviderUrl(), value)) {
                changed = true;
                if (!pretend) {
                    this.setProviderUrl(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("security-authentication")) {
            if (ConnectionPoolDefinition.isChanged(this.getSecurityAuthentication(), value)) {
                changed = true;
                if (!pretend) {
                    this.setSecurityAuthentication(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.security-principal")) {
            if (ConnectionPoolDefinition.isChanged(this.getSecurityPrincipal(), value)) {
                changed = true;
                if (!pretend) {
                    this.setSecurityPrincipal(value.length() > 0 ? value : null);
                }
            }
        } else if (key.equals("proxool.security-credentials") && ConnectionPoolDefinition.isChanged(this.getSecurityCredentials(), value)) {
            changed = true;
            if (!pretend) {
                this.setSecurityCredentials(value.length() > 0 ? value : null);
            }
        }
        return changed;
    }

    private int getInt(String key, String value) throws ProxoolException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ProxoolException("'" + key + "' property must be an integer. Found '" + value + "' instead.");
        }
    }

    private static boolean isChanged(String oldValue, String newValue) {
        boolean changed = false;
        if (oldValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else if (newValue == null) {
            changed = true;
        } else if (!oldValue.equals(newValue)) {
            changed = true;
        }
        return changed;
    }

    private void reset() {
        this.completeUrl = null;
        this.delegateProperties.clear();
        this.completeInfo.clear();
        this.changedInfo.clear();
        this.url = null;
        this.driver = null;
        this.maximumConnectionLifetime = 14400000;
        this.prototypeCount = 0;
        this.minimumConnectionCount = 0;
        this.maximumConnectionCount = 15;
        this.houseKeepingSleepTime = 30000;
        this.houseKeepingTestSql = null;
        this.testAfterUse = false;
        this.testBeforeUse = false;
        this.simultaneousBuildThrottle = 10;
        this.recentlyStartedThreshold = 60000;
        this.overloadWithoutRefusalLifetime = 60000;
        this.maximumActiveTime = 300000;
        this.verbose = false;
        this.trace = false;
        this.statistics = null;
        this.statisticsLogLevel = null;
        this.fatalSqlExceptions.clear();
        this.fatalSqlExceptionWrapper = null;
    }

    protected Properties getCompleteInfo() {
        return this.completeInfo;
    }

    public String getUser() {
        return this.getDelegateProperty("user");
    }

    public void setUser(String user) {
        this.setDelegateProperty("user", user);
    }

    public String getPassword() {
        return this.getDelegateProperty("password");
    }

    public void setPassword(String password) {
        this.setDelegateProperty("password", password);
    }

    public String getJdbcDriverVersion() {
        try {
            Driver driver = DriverManager.getDriver(this.getUrl());
            return driver.getMajorVersion() + "." + driver.getMinorVersion();
        }
        catch (SQLException e) {
            return "Trying to locate driver version for '" + this.getUrl() + "' caused: " + e.toString();
        }
        catch (NullPointerException e) {
            return "Couldn't locate driver for '" + this.getUrl() + "'!";
        }
    }

    public String toString() {
        return this.getCompleteUrl();
    }

    public String getName() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getMaximumConnectionLifetime() {
        return this.maximumConnectionLifetime;
    }

    public void setMaximumConnectionLifetime(int maximumConnectionLifetime) {
        this.maximumConnectionLifetime = maximumConnectionLifetime;
    }

    public int getPrototypeCount() {
        return this.prototypeCount;
    }

    public void setPrototypeCount(int prototypeCount) {
        this.prototypeCount = prototypeCount;
    }

    public int getMinimumConnectionCount() {
        return this.minimumConnectionCount;
    }

    public void setMinimumConnectionCount(int minimumConnectionCount) {
        this.minimumConnectionCount = minimumConnectionCount;
    }

    public int getMaximumConnectionCount() {
        return this.maximumConnectionCount;
    }

    public void setMaximumConnectionCount(int maximumConnectionCount) {
        this.maximumConnectionCount = maximumConnectionCount;
    }

    public int getHouseKeepingSleepTime() {
        return this.houseKeepingSleepTime;
    }

    public void setHouseKeepingSleepTime(int houseKeepingSleepTime) {
        this.houseKeepingSleepTime = houseKeepingSleepTime;
    }

    public int getMaximumNewConnections() {
        return this.simultaneousBuildThrottle;
    }

    public void setMaximumNewConnections(int maximumNewConnections) {
        this.simultaneousBuildThrottle = maximumNewConnections;
    }

    public int getSimultaneousBuildThrottle() {
        return this.simultaneousBuildThrottle;
    }

    public void setSimultaneousBuildThrottle(int simultaneousBuildThrottle) {
        this.simultaneousBuildThrottle = simultaneousBuildThrottle;
    }

    public Properties getProperties() {
        return this.delegateProperties;
    }

    public Properties getDelegateProperties() {
        return this.delegateProperties;
    }

    public String getDelegateProperty(String name) {
        return this.getDelegateProperties().getProperty(name);
    }

    public void setDelegateProperty(String name, String value) {
        this.connectionPropertiesChanged = true;
        this.getDelegateProperties().setProperty(name, value);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.connectionPropertiesChanged = true;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        this.connectionPropertiesChanged = true;
    }

    public int getRecentlyStartedThreshold() {
        return this.recentlyStartedThreshold;
    }

    public void setRecentlyStartedThreshold(int recentlyStartedThreshold) {
        this.recentlyStartedThreshold = recentlyStartedThreshold;
    }

    public int getOverloadWithoutRefusalLifetime() {
        return this.overloadWithoutRefusalLifetime;
    }

    public void setOverloadWithoutRefusalLifetime(int overloadWithoutRefusalLifetime) {
        this.overloadWithoutRefusalLifetime = overloadWithoutRefusalLifetime;
    }

    public int getMaximumActiveTime() {
        return this.maximumActiveTime;
    }

    public void setMaximumActiveTime(int maximumActiveTime) {
        this.maximumActiveTime = maximumActiveTime;
    }

    public int getDebugLevel() {
        return this.verbose ? 1 : 0;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String getCompleteUrl() {
        return this.completeUrl;
    }

    public void setCompleteUrl(String completeUrl) {
        this.completeUrl = completeUrl;
    }

    public void setFatalSqlExceptionsAsString(String fatalSqlExceptionsAsString) {
        this.fatalSqlExceptionsAsString = fatalSqlExceptionsAsString;
        this.fatalSqlExceptions.clear();
        if (fatalSqlExceptionsAsString != null) {
            StringTokenizer st = new StringTokenizer(fatalSqlExceptionsAsString, ",");
            while (st.hasMoreTokens()) {
                this.fatalSqlExceptions.add(st.nextToken().trim());
            }
        }
    }

    public Set getFatalSqlExceptions() {
        return this.fatalSqlExceptions;
    }

    public String getFatalSqlExceptionWrapper() {
        return this.fatalSqlExceptionWrapper;
    }

    public void setFatalSqlExceptionWrapper(String fatalSqlExceptionWrapper) throws ProxoolException {
        try {
            FatalSqlExceptionHelper.throwFatalSQLException(fatalSqlExceptionWrapper, new SQLException("Test"));
        }
        catch (SQLException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.fatalSqlExceptionWrapper = fatalSqlExceptionWrapper;
    }

    public String getHouseKeepingTestSql() {
        return this.houseKeepingTestSql;
    }

    public void setHouseKeepingTestSql(String houseKeepingTestSql) {
        this.houseKeepingTestSql = houseKeepingTestSql;
    }

    public boolean isTestBeforeUse() {
        return this.testBeforeUse;
    }

    public void setTestBeforeUse(boolean testBeforeUse) {
        this.testBeforeUse = testBeforeUse;
    }

    public boolean isTestAfterUse() {
        return this.testAfterUse;
    }

    public void setTestAfterUse(boolean testAfterUse) {
        this.testAfterUse = testAfterUse;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public String getStatisticsLogLevel() {
        return this.statisticsLogLevel;
    }

    public void setStatisticsLogLevel(String statisticsLogLevel) {
        this.statisticsLogLevel = statisticsLogLevel;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public boolean isEqual(String url, Properties info) {
        try {
            return !this.doChange(url, info, true, false);
        }
        catch (ProxoolException e) {
            LOG.error("Problem checking equality", e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

