/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.batch;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.factories.annotations.Inject;

public class BatchContainer {
    TransactionManager transactionManager;
    private ThreadLocal<Transaction> batchTransactionContainer = new ThreadLocal();

    @Inject
    void inject(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void startBatch() throws CacheException {
        try {
            if (this.transactionManager.getTransaction() != null) {
                return;
            }
            if (this.batchTransactionContainer.get() == null) {
                this.transactionManager.begin();
                this.batchTransactionContainer.set(this.transactionManager.suspend());
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to start batch", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endBatch(boolean success) {
        Transaction tx = this.batchTransactionContainer.get();
        if (tx == null) {
            return;
        }
        Transaction existingTx = null;
        try {
            try {
                existingTx = this.transactionManager.getTransaction();
                this.transactionManager.resume(tx);
                if (success) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to end batch", e);
            }
            Object var6_4 = null;
            this.batchTransactionContainer.remove();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.batchTransactionContainer.remove();
            try {
                if (existingTx == null) throw throwable;
                this.transactionManager.resume(existingTx);
                throw throwable;
            }
            catch (Exception e) {
                throw new CacheException("Failed resuming existing transaction " + existingTx, e);
            }
        }
        try {}
        catch (Exception e) {
            throw new CacheException("Failed resuming existing transaction " + existingTx, e);
        }
        if (existingTx == null) return;
        this.transactionManager.resume(existingTx);
    }

    public Transaction getBatchTransaction() {
        return this.batchTransactionContainer.get();
    }
}

