/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <syslog.h>
#if defined(SYSV) || defined(FREEBSD) || defined(OPENBSD)
#include <string.h>
#else
#include <strings.h>
#endif

#include "x10.h"
#include "process.h"


#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern int timeout;
extern int sptty;
extern int i_am_monitor, i_am_state, i_am_relay;
extern int heyu_parent;
extern void x10state_init_all();
extern int read_x10state_file();
extern CONFIG config;

void iquit();
jmp_buf mjb;

void iquit( int signo )
{
    longjmp(mjb, 1);
}

int c_monitor( int argc, char *argv[] )
{
    off_t f_offset;
    int check4poll();
    struct stat stat_buf;
    char spoolfile[100];
#ifdef HASSELECT
#include <fcntl.h>
    extern int tty;
    int newfd;
    int rtn;
    fd_set rfds;
    struct timeval tv;
    newfd=dup(tty);
#endif

    sprintf( spoolfile, "%s/%s%s", SPOOLDIR, SPOOLFILE, config.suffix);
    (void) signal(SIGCHLD, iquit);
    (void) signal(SIGINT, iquit);
    if (setjmp(mjb))
	return(0);

    i_am_monitor = 1;
     
    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
    while (1)  {
	if( f_offset == lseek(sptty, 0, SEEK_END) )  {  /* find end of file */
	    if( stat( spoolfile, &stat_buf ) < 0)
	        return(0); 
#ifndef HASSELECT
	    /* this imposes a 1 second delay between the start of new output*/
	    /* It keeps the disk from being thrashed. */
	    sleep(1);
#else
	    FD_CLR(newfd, &rfds);
	    FD_SET(newfd, &rfds);
	    tv.tv_sec = 0;	/* This does it even better */
	    tv.tv_usec = 500;
	    if( (rtn = select(1 ,NULL, NULL, NULL, &tv)) < 0 )
		perror("select failed\n");
#endif
	}
	else {
	    if( fstat( sptty, &stat_buf ) < 0)
	         return(0);
	    lseek(sptty, f_offset, SEEK_SET);
	    check4poll(1,1);
	    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
	}
    }
    /* return(0); */
}

int c_engine( int argc, char *argv[] )
{
    off_t f_offset;
    int check4poll();
    struct stat stat_buf;
    char spoolfile[100];
#ifdef HASSELECT
#include <fcntl.h>
    extern int tty;
    int newfd;
    int rtn;
    fd_set rfds;
    struct timeval tv;
    newfd=dup(tty);
#endif

    sprintf( spoolfile, "%s/%s%s", SPOOLDIR, SPOOLFILE, config.suffix);

    (void) signal(SIGINT, iquit);
    if (setjmp(mjb))
	return(0);

    i_am_state = 1;
    i_am_monitor = 1;
    heyu_parent = D_CMDLINE;

    openlog( "heyu_engine", 0, LOG_DAEMON);
    syslog(LOG_ERR, "engine setting up-\n");

    if ( read_x10state_file() != 0 )
       x10state_init_all();
     
    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
 

    while (1) {
	if ( f_offset == lseek(sptty, 0, SEEK_END) )  {  /* find end of file */
	    if( stat( spoolfile, &stat_buf ) < 0)
	        return(0); 
#ifndef HASSELECT
	    /* this imposes a 1 second delay between the start of new output*/
	    /* It keeps the disk from being thrashed. */
	    sleep(1);
#else
	    FD_CLR(newfd, &rfds);
	    FD_SET(newfd, &rfds);
	    tv.tv_sec = 0;	/* This does it even better */
	    tv.tv_usec = 500;
	    if( (rtn = select(1 ,NULL, NULL, NULL, &tv)) < 0 )
		perror("select failed\n");
#endif
	}
	else {
	    if ( fstat( sptty, &stat_buf ) < 0)
	         return(0);
	    lseek(sptty, f_offset, SEEK_SET);
	    check4poll(1,1);
	    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
	}
    }
    /* return(0); */
}

