try:
	from setuptools import setup
except ImportError:
	from distutils.core import setup

import os

def read(fname):
    return open(os.path.join(os.path.dirname(__file__),"heapCL", fname)).read()

long_desc = """
	HeapCL allows you to create messages, people, prospects and email templates from the command line. Why might you want to do this? Because if you have terminal access you can build this into an automation routine where otherwise you might need to hire a programmer.
"""


setup(name="HeapCL",
      version=read("version.txt"),
      description="Heap CRM's command line interface",
      author="Ben Smith",
      author_email="ben@wbpsystems.com",
      url="http://heap.wbpsystems.com/cl.php",
      license="Apache Software License",
      packages=['poster','UnicodeCSV','WebBrowser'],
	  scripts=['heapCL/heapCL'],
	  package_dir={'poster':'heapCL/poster','UnicodeCSV':'heapCL/UnicodeCSV','WebBrowser':'heapCL/WebBrowser'},
      long_description=long_desc,
      classifiers=[
          'Topic :: Internet :: WWW/HTTP',
          'Environment :: Console',
          'Development Status :: 5 - Production/Stable',
          'Operating System :: POSIX',
          'Intended Audience :: Developers',
          'Intended Audience :: End Users/Desktop'
      ]
     )
