/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import java.io.FileInputStream;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class BigFileTest {
    @Test
    public void test() throws Exception {
        try {
            String fname = System.getenv("BIGFILETEST");
            if (fname == null) {
                System.out.println("BIGFILETEST environment not set.  Returning without test");
                return;
            }
            System.out.println("Big file test.  Takes quite a while.");
            byte[] buf = new byte[100000000];
            BufferedFile bf = new BufferedFile(fname, "rw");
            byte sample = 13;
            for (int i = 0; i < 30; ++i) {
                bf.write(buf);
                if (i != 24) continue;
                bf.write(new byte[]{sample});
            }
            bf.close();
            bf = new BufferedFile(fname, "r");
            long skip = 2500000000L;
            long val1 = bf.skipBytes(skip);
            long val2 = bf.getFilePointer();
            int val = bf.read();
            bf.close();
            Assert.assertEquals((String)"SkipResult", (long)skip, (long)val1);
            Assert.assertEquals((String)"SkipPos", (long)skip, (long)val2);
            Assert.assertEquals((String)"SkipVal", (long)sample, (long)val);
            BufferedDataInputStream bdis = new BufferedDataInputStream(new FileInputStream(fname));
            val1 = bdis.skipBytes(skip);
            val = bdis.read();
            bdis.close();
            Assert.assertEquals((String)"SSkipResult", (long)skip, (long)val1);
            Assert.assertEquals((String)"SSkipVal", (long)sample, (long)val);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }
}

