/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import junit.framework.TestCase;
import nom.tam.util.ArrayFuncs;

public class ArrayFuncsTest
extends TestCase {
    public ArrayFuncsTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testComputeSize() {
        System.out.println("computeSize");
        Object o = null;
        int expResult = 0;
        int result = ArrayFuncs.computeSize(o);
        ArrayFuncsTest.assertEquals((int)expResult, (int)result);
        int[][] x = new int[2][3];
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize(x), (int)24);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize(new double[3]), (int)24);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize("1234"), (int)4);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize(new Object()), (int)0);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize(new Double[5]), (int)0);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.computeSize(new Double[]{new Double(0.0), new Double(1.0), new Double(2.0)}), (int)24);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize(x), (long)24L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize(new double[3]), (long)24L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize("1234"), (long)4L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize(new Object()), (long)0L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize(new Double[5]), (long)0L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.computeLSize(new Double[]{new Double(0.0), new Double(1.0), new Double(2.0)}), (long)24L);
    }

    public void testNElements() {
        System.out.println("nElements");
        Object o = null;
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.nElements(null), (int)0);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.nElements(new int[2][2][3]), (int)12);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.nLElements(null), (long)0L);
        ArrayFuncsTest.assertEquals((long)ArrayFuncs.nLElements(new int[2][2][3]), (long)12L);
    }

    public void testDeepClone() {
        int[][] test = new int[][]{{0, 1}, {2, 3}, {4, 5}};
        int[][] result = (int[][])ArrayFuncs.deepClone(test);
        for (int i = 0; i < test.length; ++i) {
            for (int j = 0; j < test[i].length; ++j) {
                ArrayFuncsTest.assertEquals((int)test[i][j], (int)result[i][j]);
            }
        }
    }

    public void testGenericClone() {
        System.out.println("genericClone");
        int[] o = new int[]{1, 2, 3};
        Object result = ArrayFuncs.genericClone(o);
        int[] x = o;
        int[] y = (int[])result;
        for (int i = 0; i < x.length; ++i) {
            ArrayFuncsTest.assertEquals((int)x[i], (int)y[i]);
        }
        CloneTest xa = new CloneTest();
        xa.value = 4;
        Object ya = ArrayFuncs.genericClone(xa);
        ArrayFuncsTest.assertTrue((xa != ya ? 1 : 0) != 0);
        ArrayFuncsTest.assertTrue((boolean)xa.equals(ya));
    }

    public void testCopyArray() {
        System.out.println("copyArray");
        double[] start = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double[] finish = new double[6];
        ArrayFuncs.copyArray(start, finish);
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.arrayEquals(start, finish));
    }

    public void testGetDimensions() {
        System.out.println("getDimensions");
        Object o = null;
        Object expResult = null;
        int[] result = ArrayFuncs.getDimensions(o);
        ArrayFuncsTest.assertEquals(expResult, (Object)result);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getDimensions(new Integer(0)).length, (int)0);
        int[][] test = new int[2][3];
        int[] dims = ArrayFuncs.getDimensions(test);
        ArrayFuncsTest.assertEquals((int)dims.length, (int)2);
        ArrayFuncsTest.assertEquals((int)dims[0], (int)2);
        ArrayFuncsTest.assertEquals((int)dims[1], (int)3);
    }

    public void testGetBaseArray() {
        int[][][] test = new int[2][3][4];
        byte b = 0;
        ArrayFuncs.testPattern(test, b);
        ArrayFuncsTest.assertEquals((Object)ArrayFuncs.getBaseArray(test), (Object)test[0][0]);
    }

    public void testGetBaseClass() {
        System.out.println("getBaseClass");
        ArrayFuncsTest.assertEquals((Object)ArrayFuncs.getBaseClass(new int[2][3]), Integer.TYPE);
        ArrayFuncsTest.assertEquals((Object)ArrayFuncs.getBaseClass(new String[3]), String.class);
    }

    public void testGetBaseLength() {
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new int[2][3]), (int)4);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new double[2][3]), (int)8);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new byte[2][3]), (int)1);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new short[2][3]), (int)2);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new int[2][3]), (int)4);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new char[2][3]), (int)2);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new float[2][3]), (int)4);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new boolean[2][3]), (int)1);
        ArrayFuncsTest.assertEquals((int)ArrayFuncs.getBaseLength(new Object[2][3]), (int)-1);
    }

    public void testGenerateArray() {
        System.out.println("generateArray");
        Class<Integer> baseType = Integer.TYPE;
        int[] dims = new int[]{2, 3, 4};
        Object result = ArrayFuncs.generateArray(baseType, dims);
        ArrayFuncsTest.assertEquals(result.getClass(), int[][][].class);
        int[][][] x = (int[][][])result;
        ArrayFuncsTest.assertEquals((int)x.length, (int)2);
        ArrayFuncsTest.assertEquals((int)x[0].length, (int)3);
        ArrayFuncsTest.assertEquals((int)x[0][0].length, (int)4);
    }

    public void testTestPattern() {
        System.out.println("testPattern");
        byte start = 2;
        int[] arr = new int[8];
        boolean expResult = false;
        byte result = ArrayFuncs.testPattern(arr, start);
        ArrayFuncsTest.assertEquals((byte)result, (byte)((byte)(start + arr.length)));
        ArrayFuncsTest.assertEquals((int)start, (int)arr[0]);
        ArrayFuncsTest.assertEquals((int)(start + arr.length - 1), (int)arr[arr.length - 1]);
    }

    public void testFlatten() {
        System.out.println("flatten");
        int[][][] test = new int[2][3][4];
        int[] result = (int[])ArrayFuncs.flatten(test);
        ArrayFuncsTest.assertEquals((int)result.length, (int)24);
    }

    public void testCurl() {
        System.out.println("curl");
        int[] dimens = new int[]{2, 3, 4};
        int[] test = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        int[][][] res = (int[][][])ArrayFuncs.curl(test, dimens);
        ArrayFuncsTest.assertEquals((int)res.length, (int)2);
        ArrayFuncsTest.assertEquals((int)res[0].length, (int)3);
        ArrayFuncsTest.assertEquals((int)res[0][0].length, (int)4);
        ArrayFuncsTest.assertEquals((int)res[0][0][0], (int)0);
        ArrayFuncsTest.assertEquals((int)res[0][0][3], (int)3);
        ArrayFuncsTest.assertEquals((int)res[1][2][3], (int)23);
    }

    public void testMimicArray() {
        System.out.println("mimicArray");
        int[][] array = new int[2][3];
        Class<Double> newType = Double.TYPE;
        double[][] result = (double[][])ArrayFuncs.mimicArray(array, newType);
        ArrayFuncsTest.assertEquals((int)result.length, (int)array.length);
        ArrayFuncsTest.assertEquals((int)result[0].length, (int)array[0].length);
    }

    public void testConvertArray() {
        System.out.println("convertArray");
        int[][] array = new int[][]{{1, 2, 3}, {4, 5, 6}};
        Class<Number> newType = Double.TYPE;
        boolean reuse = true;
        double[][] dres = (double[][])ArrayFuncs.convertArray(array, newType, reuse);
        ArrayFuncsTest.assertEquals((int)dres.length, (int)array.length);
        ArrayFuncsTest.assertEquals((int)dres[0].length, (int)array[0].length);
        newType = Integer.TYPE;
        int[][] ires = (int[][])ArrayFuncs.convertArray(array, newType, true);
        ArrayFuncsTest.assertEquals((Object)array, (Object)ires);
        ires = (int[][])ArrayFuncs.convertArray(array, newType, false);
        ArrayFuncsTest.assertNotSame((Object)array, (Object)ires);
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.arrayEquals(array, ires));
    }

    public void testCopyInto() {
        System.out.println("copyInto");
        int[][] x = new int[][]{{2, 3, 4}, {5, 6, 7}};
        double[][] y = new double[2][3];
        ArrayFuncs.copyInto(x, y);
        ArrayFuncsTest.assertEquals((Object)x[0][0], (Object)y[0][0]);
        ArrayFuncsTest.assertEquals((Object)x[1][2], (Object)y[1][2]);
    }

    public void testArrayEquals() {
        System.out.println("arrayEquals");
        int[][] x = new int[][]{{1, 2, 3}, {4, 5, 6}};
        int[][] y = new int[][]{{1, 2, 3}, {4, 5, 6}};
        int[][] z = new int[][]{{1, 2, 3}, {4, 5, 7}};
        int[][] t = new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.arrayEquals(null, null));
        ArrayFuncsTest.assertFalse((boolean)ArrayFuncs.arrayEquals(null, new int[2]));
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.arrayEquals(x, y));
        ArrayFuncsTest.assertFalse((boolean)ArrayFuncs.arrayEquals(x, z));
        ArrayFuncsTest.assertFalse((boolean)ArrayFuncs.arrayEquals(x, t));
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.arrayEquals(x[0], z[0]));
    }

    public void testDoubleArrayEquals() {
        double[] x = new double[]{1.0, 2.0, 3.0};
        double[] y = new double[]{1.0, 2.0, 3.0};
        System.out.println("doubleArrayEquals");
        double tol = 0.0;
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.doubleArrayEquals(x, y, tol));
        x[0] = x[0] + 1.0E-14;
        ArrayFuncsTest.assertFalse((boolean)ArrayFuncs.doubleArrayEquals(x, y, tol));
        tol = 1.0E-13;
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.doubleArrayEquals(x, y, tol));
    }

    public void testFloatArrayEquals() {
        float[] x = new float[]{1.0f, 2.0f, 3.0f};
        float[] y = new float[]{1.0f, 2.0f, 3.0f};
        System.out.println("floatArrayEquals");
        float tol = 0.0f;
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.floatArrayEquals(x, y, tol));
        x[0] = x[0] + 1.0E-6f;
        ArrayFuncsTest.assertFalse((boolean)ArrayFuncs.floatArrayEquals(x, y, tol));
        tol = 1.0E-5f;
        ArrayFuncsTest.assertTrue((boolean)ArrayFuncs.floatArrayEquals(x, y, tol));
    }

    public class CloneTest
    implements Cloneable {
        public int value = 2;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean equals(Object x) {
            return x instanceof CloneTest && ((CloneTest)x).value == this.value;
        }
    }
}

