/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.jvnet.sorcerer.util.IteratorAdapter;
import org.jvnet.sorcerer.util.JavaFileObjectDelegate;
import org.jvnet.sorcerer.util.StandardJavaFileManagerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabExpandingFileManager
extends StandardJavaFileManagerDelegate {
    private final int tabWidth;
    private final Charset charset;

    public TabExpandingFileManager(StandardJavaFileManager core, Charset charset, int tabWidth) {
        super(core);
        this.charset = charset;
        this.tabWidth = tabWidth;
    }

    private Iterable<JavaFileObject> wrap(final Iterable<? extends JavaFileObject> core) {
        return new Iterable<JavaFileObject>(){

            @Override
            public Iterator<JavaFileObject> iterator() {
                return new IteratorAdapter<JavaFileObject, JavaFileObject>(core.iterator()){

                    @Override
                    protected JavaFileObject filter(JavaFileObject u) {
                        return new JavaFileObjectImpl(u);
                    }
                };
            }
        };
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.wrap(super.getJavaFileObjectsFromFiles(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.wrap(super.getJavaFileObjects(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.wrap(super.getJavaFileObjectsFromStrings(names));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.wrap(super.getJavaFileObjects(names));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.wrap(super.list(location, packageName, kinds, recurse));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return new JavaFileObjectImpl(super.getJavaFileForInput(location, className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.core.inferBinaryName(location, ((JavaFileObjectImpl)file).getCore());
    }

    private final class JavaFileObjectImpl
    extends JavaFileObjectDelegate {
        public JavaFileObjectImpl(JavaFileObject core) {
            super(core);
        }

        JavaFileObject getCore() {
            return this.core;
        }

        public InputStream openInputStream() throws IOException {
            return super.openInputStream();
        }

        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException();
        }

        public StringBuilder getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharSequence cs = super.getCharContent(ignoreEncodingErrors);
            StringBuilder sb = new StringBuilder(cs.length());
            int pos = 0;
            for (int i = 0; i < cs.length(); ++i) {
                char ch = cs.charAt(i);
                if (ch == '\t') {
                    int nextStop = (pos / TabExpandingFileManager.this.tabWidth + 1) * TabExpandingFileManager.this.tabWidth;
                    while (pos < nextStop) {
                        sb.append(' ');
                        ++pos;
                    }
                    continue;
                }
                sb.append(ch);
                if (ch == '\r' || ch == '\n') {
                    pos = 0;
                    continue;
                }
                ++pos;
            }
            return sb;
        }
    }
}

