/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import java.util.Set;
import java.util.TreeSet;
import org.jvnet.sorcerer.util.JsonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PkgInfo<T extends PkgInfo<T>>
implements Comparable<T>,
JsonWriter.Writable {
    final String name;
    final Set<T> children = new TreeSet<T>();

    public PkgInfo(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(T that) {
        return this.name.compareTo(((PkgInfo)that).name);
    }

    public T add(String name) {
        String rest;
        String head;
        if (name.length() == 0) {
            return (T)this;
        }
        int idx = name.indexOf(46);
        if (idx >= 0) {
            head = name.substring(0, idx);
            rest = name.substring(idx + 1);
        } else {
            head = name;
            rest = "";
        }
        for (PkgInfo c : this.children) {
            if (!c.name.equals(head)) continue;
            return c.add(rest);
        }
        T c = this.create(head);
        this.children.add(c);
        return ((PkgInfo)c).add(rest);
    }

    @Override
    public void write(JsonWriter js) {
        js.property("name", this.name);
        if (!this.children.isEmpty()) {
            js.property("children", this.children);
        }
    }

    protected abstract T create(String var1);
}

