/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import antlr.Token;
import antlr.TokenStreamException;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jvnet.sorcerer.AstGenerator;
import org.jvnet.sorcerer.ClassReferenceBuilder;
import org.jvnet.sorcerer.Dependency;
import org.jvnet.sorcerer.ParsedType;
import org.jvnet.sorcerer.ReservedWords;
import org.jvnet.sorcerer.SourcePositionsWrapper;
import org.jvnet.sorcerer.Tag;
import org.jvnet.sorcerer.impl.JavaLexer;
import org.jvnet.sorcerer.util.CharSequenceReader;
import org.jvnet.sorcerer.util.TreeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedSourceSet {
    private final Trees trees;
    private final SourcePositions srcPos;
    private final Elements elements;
    private final Types types;
    private final List<CompilationUnitTree> compilationUnits = new ArrayList<CompilationUnitTree>();
    private final Map<String, TreePath> classes = new TreeMap<String, TreePath>();
    private final Set<PackageElement> packages = new TreeSet<PackageElement>(PACKAGENAME_COMPARATOR);
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final int tabWidth;
    final Map<TypeElement, ParsedType> parsedTypes = new HashMap<TypeElement, ParsedType>();
    final Map<ClassTree, TreePath> treePathByClass = new HashMap<ClassTree, TreePath>();
    public static final Comparator<PackageElement> PACKAGENAME_COMPARATOR = new Comparator<PackageElement>(){

        @Override
        public int compare(PackageElement lhs, PackageElement rhs) {
            return lhs.getQualifiedName().toString().compareTo(rhs.getQualifiedName().toString());
        }
    };
    public static final Comparator<Element> SIMPLENAME_COMPARATOR = new Comparator<Element>(){

        @Override
        public int compare(Element lhs, Element rhs) {
            return lhs.getSimpleName().toString().compareTo(rhs.getSimpleName().toString());
        }
    };
    private static final Comparator<TypeElement> TYPE_COMPARATOR = new Comparator<TypeElement>(){

        @Override
        public int compare(TypeElement lhs, TypeElement rhs) {
            return lhs.getQualifiedName().toString().compareTo(rhs.getQualifiedName().toString());
        }
    };

    public ParsedSourceSet(JavacTask javac, int tabWidth) throws IOException {
        this.trees = Trees.instance(javac);
        this.elements = javac.getElements();
        this.types = javac.getTypes();
        this.srcPos = new SourcePositionsWrapper(this.trees.getSourcePositions());
        this.tabWidth = tabWidth;
        Iterable<? extends CompilationUnitTree> parsed = javac.parse();
        javac.analyze();
        TreePathScanner<Void, Void> classScanner = new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree ct, Void _) {
                TreePath path = this.getCurrentPath();
                ParsedSourceSet.this.treePathByClass.put(ct, path);
                TypeElement e = (TypeElement)ParsedSourceSet.this.trees.getElement(path);
                if (e != null) {
                    ParsedSourceSet.this.classes.put(e.getQualifiedName().toString(), path);
                    ParsedSourceSet.this.getParsedType(e);
                    Element p = e.getEnclosingElement();
                    if (p.getKind() == ElementKind.PACKAGE) {
                        ParsedSourceSet.this.packages.add((PackageElement)p);
                    }
                }
                return (Void)super.visitClass(ct, _);
            }
        };
        for (CompilationUnitTree compilationUnitTree : parsed) {
            this.compilationUnits.add(compilationUnitTree);
            classScanner.scan(compilationUnitTree, null);
        }
        for (Map.Entry entry : ClassReferenceBuilder.build(this.compilationUnits).entrySet()) {
            this.getParsedType((TypeElement)((TypeElement)entry.getKey())).referers = ((Set)entry.getValue()).toArray(new CompilationUnitTree[((Set)entry.getValue()).size()]);
        }
    }

    public List<CompilationUnitTree> getCompilationUnits() {
        return Collections.unmodifiableList(this.compilationUnits);
    }

    public Collection<TreePath> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Map<ClassTree, TreePath> getTreePathByClass() {
        return this.treePathByClass;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency d) {
        this.dependencies.add(d);
    }

    public Collection<TypeElement> getClassElements() {
        return Collections.unmodifiableCollection(this.parsedTypes.keySet());
    }

    public Collection<TypeElement> getClassElements(PackageElement pkg) {
        TreeSet<TypeElement> r = new TreeSet<TypeElement>(TYPE_COMPARATOR);
        for (TypeElement e : this.parsedTypes.keySet()) {
            Element p = e.getEnclosingElement();
            if (!((Object)p).equals(pkg)) continue;
            r.add(e);
        }
        return r;
    }

    public Collection<PackageElement> getPackageElement() {
        return Collections.unmodifiableCollection(this.packages);
    }

    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(this.classes.keySet());
    }

    public TreePath getClassTreePath(String fullyQualifiedClassName) {
        return this.classes.get(fullyQualifiedClassName);
    }

    public Trees getTrees() {
        return this.trees;
    }

    public SourcePositions getSourcePositions() {
        return this.srcPos;
    }

    public Elements getElements() {
        return this.elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public ParsedType getParsedType(TypeElement e) {
        ParsedType v = this.parsedTypes.get(e);
        if (v == null) {
            return new ParsedType(this, e);
        }
        return v;
    }

    public Collection<ParsedType> getParsedTypes() {
        return this.parsedTypes.values();
    }

    protected void configure(final CompilationUnitTree cu, final AstGenerator gen) throws IOException {
        final LineMap lineMap = cu.getLineMap();
        JavaLexer lexer = new JavaLexer(new CharSequenceReader(gen.sourceFile));
        lexer.setTabSize(this.tabWidth);
        try {
            Token token;
            int type;
            Stack<Long> openBraces = new Stack<Long>();
            while ((type = (token = lexer.nextToken()).getType()) != 1) {
                long sp;
                if (type == 59 && ReservedWords.LIST.contains(token.getText())) {
                    gen.add(new Tag.ReservedWord(lineMap, token));
                }
                if (type == 51 || type == 50) {
                    gen.add(new Tag.Comment(lineMap, token));
                }
                if (type == 9 || type == 5) {
                    openBraces.push(this.getPosition(lineMap, token));
                    gen.add(new Tag.Killer(lineMap, token));
                }
                if (type == 10) {
                    sp = (Long)openBraces.pop();
                    gen.add(new Tag.CurlyBracket(sp, this.getPosition(lineMap, token) + 1L));
                    gen.add(new Tag.Killer(lineMap, token));
                }
                if (type != 6) continue;
                sp = (Long)openBraces.pop();
                gen.add(new Tag.Parenthesis(sp, this.getPosition(lineMap, token) + 1L));
                gen.add(new Tag.Killer(lineMap, token));
            }
        }
        catch (TokenStreamException e) {
            // empty catch block
        }
        final Name CLASS = this.elements.getName("class");
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitPrimitiveType(PrimitiveTypeTree pt, Void _) {
                return (Void)super.visitPrimitiveType(pt, _);
            }

            @Override
            public Void visitLiteral(LiteralTree lit, Void _) {
                gen.add(new Tag.Literal(cu, ParsedSourceSet.this.srcPos, lit));
                return (Void)super.visitLiteral(lit, _);
            }

            @Override
            public Void visitVariable(VariableTree vt, Void _) {
                VariableElement e = (VariableElement)TreeUtil.getElement(vt);
                if (e != null) {
                    switch (e.getKind()) {
                        case ENUM_CONSTANT: 
                        case FIELD: {
                            gen.add(new Tag.FieldDecl(cu, ParsedSourceSet.this.srcPos, vt));
                            break;
                        }
                        case EXCEPTION_PARAMETER: 
                        case LOCAL_VARIABLE: 
                        case PARAMETER: {
                            gen.add(new Tag.LocalVarDecl(cu, ParsedSourceSet.this.srcPos, vt, e));
                        }
                    }
                    Token token = e.getKind() != ElementKind.ENUM_CONSTANT ? gen.findTokenAfter(vt.getType(), true, vt.getName().toString()) : gen.findTokenAfter(vt, false, vt.getName().toString());
                    if (token != null) {
                        gen.add(new Tag.DeclName(lineMap, token));
                    }
                }
                return (Void)super.visitVariable(vt, _);
            }

            @Override
            public Void visitMethod(MethodTree mt, Void _) {
                ExecutableElement e = (ExecutableElement)TreeUtil.getElement(mt);
                if (e != null) {
                    if (e.getKind() == ElementKind.CONSTRUCTOR && e.getEnclosingElement().getSimpleName().length() == 0) {
                        return _;
                    }
                    Tree prev = mt.getReturnType();
                    String name = mt.getName().toString();
                    Token token = prev != null ? gen.findTokenAfter(prev, true, name) : gen.findTokenAfter(mt, false, name);
                    if (token != null) {
                        gen.add(new Tag.DeclName(lineMap, token));
                    }
                    ParsedType pt = ParsedSourceSet.this.getParsedType((TypeElement)e.getEnclosingElement());
                    gen.add(new Tag.MethodDecl(cu, ParsedSourceSet.this.srcPos, mt, e, pt.findOverriddenMethods(ParsedSourceSet.this.elements, e), pt.findOverridingMethods(ParsedSourceSet.this.elements, e)));
                }
                return (Void)super.visitMethod(mt, _);
            }

            @Override
            public Void visitClass(ClassTree ct, Void _) {
                TypeElement e = (TypeElement)TreeUtil.getElement(ct);
                if (e != null) {
                    Token token = ct.getModifiers() != null ? gen.findTokenAfter(ct.getModifiers(), true, ct.getSimpleName().toString()) : gen.findTokenAfter(ct, false, ct.getSimpleName().toString());
                    if (token != null) {
                        gen.add(new Tag.DeclName(lineMap, token));
                    }
                    List<ParsedType> descendants = ParsedSourceSet.this.getParsedType((TypeElement)e).descendants;
                    gen.add(new Tag.ClassDecl(cu, ParsedSourceSet.this.srcPos, ct, e, descendants));
                    if (e.getNestingKind() == NestingKind.ANONYMOUS) {
                        this.scan(ct.getMembers());
                        return _;
                    }
                }
                return (Void)super.visitClass(ct, _);
            }

            @Override
            public Void visitIdentifier(IdentifierTree id, Void _) {
                Element e;
                if (!ReservedWords.LIST.contains(id.getName().toString()) && (e = TreeUtil.getElement(id)) != null) {
                    switch (e.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            gen.add(new Tag.TypeRef(cu, ParsedSourceSet.this.srcPos, id, (TypeElement)e));
                            break;
                        }
                        case ENUM_CONSTANT: 
                        case FIELD: {
                            gen.add(new Tag.FieldRef(cu, ParsedSourceSet.this.srcPos, id, (VariableElement)e));
                            break;
                        }
                        case EXCEPTION_PARAMETER: 
                        case LOCAL_VARIABLE: 
                        case PARAMETER: {
                            gen.add(new Tag.LocalVarRef(cu, ParsedSourceSet.this.srcPos, id, (VariableElement)e));
                        }
                    }
                }
                return (Void)super.visitIdentifier(id, _);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree mst, Void _) {
                if (!((Object)mst.getIdentifier()).equals(CLASS)) {
                    long ep = ParsedSourceSet.this.srcPos.getEndPosition(cu, mst);
                    long sp = ep - (long)mst.getIdentifier().length();
                    Element e = TreeUtil.getElement(mst);
                    if (e != null) {
                        switch (e.getKind()) {
                            case ENUM_CONSTANT: 
                            case FIELD: {
                                gen.add(new Tag.FieldRef(sp, ep, (VariableElement)e));
                                break;
                            }
                            case ANNOTATION_TYPE: 
                            case CLASS: 
                            case ENUM: 
                            case INTERFACE: {
                                gen.add(new Tag.TypeRef(sp, ep, (TypeElement)e));
                            }
                        }
                    }
                }
                return (Void)super.visitMemberSelect(mst, _);
            }

            @Override
            public Void visitNewClass(NewClassTree nt, Void _) {
                long ep = ParsedSourceSet.this.srcPos.getEndPosition(cu, nt.getIdentifier());
                long sp = ParsedSourceSet.this.srcPos.getStartPosition(cu, nt.getIdentifier());
                Element e = TreeUtil.getElement(nt);
                if (e instanceof ExecutableElement) {
                    ExecutableElement ee = (ExecutableElement)e;
                    TypeElement ownerType = (TypeElement)ee.getEnclosingElement();
                    if (ownerType.getSimpleName().length() == 0) {
                        this.scan(nt.getIdentifier());
                    } else {
                        gen.add(new Tag.MethodRef(sp, ep, ee));
                    }
                }
                this.scan(nt.getEnclosingExpression());
                this.scan(nt.getArguments());
                this.scan(nt.getTypeArguments());
                this.scan(nt.getClassBody());
                return _;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree mi, Void _) {
                ExpressionTree ms = mi.getMethodSelect();
                Element e = TreeUtil.getElement(mi);
                if (e instanceof ExecutableElement) {
                    ExecutableElement ee = (ExecutableElement)e;
                    Name methodName = ee.getSimpleName();
                    long ep = ParsedSourceSet.this.srcPos.getEndPosition(cu, ms);
                    if (ep >= 0L) {
                        gen.add(new Tag.MethodRef(ep - (long)methodName.length(), ep, ee));
                    }
                }
                return (Void)super.visitMethodInvocation(mi, _);
            }

            private void scan(List<? extends Tree> list) {
                for (Tree tree : list) {
                    this.scan(tree);
                }
            }

            private void scan(Tree t) {
                this.scan(t, null);
            }
        }.scan(cu, null);
        ExpressionTree packageName = cu.getPackageName();
        if (packageName != null) {
            new TreeScanner<String, Void>(){

                @Override
                public String visitIdentifier(IdentifierTree id, Void _) {
                    String name = id.getName().toString();
                    PackageElement pe = ParsedSourceSet.this.elements.getPackageElement(name);
                    return name;
                }

                @Override
                public String visitMemberSelect(MemberSelectTree mst, Void _) {
                    String baseName = (String)this.scan(mst.getExpression(), _);
                    String name = mst.getIdentifier().toString();
                    if (baseName.length() > 0) {
                        name = baseName + '.' + name;
                    }
                    PackageElement pe = ParsedSourceSet.this.elements.getPackageElement(name);
                    long ep = ParsedSourceSet.this.srcPos.getEndPosition(cu, mst);
                    long sp = ep - (long)mst.getIdentifier().length();
                    return name;
                }
            }.scan(packageName, null);
        }
    }

    private long getPosition(LineMap lineMap, Token token) {
        return lineMap.getPosition(token.getLine(), token.getColumn());
    }
}

