/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.util.TreeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalVariableIdBuilder
extends AbstractElementVisitor6<StringBuilder, Void> {
    private final ParsedSourceSet pss;
    private final Trees trees;
    private final Types types;
    private final Elements elements;

    LocalVariableIdBuilder(ParsedSourceSet pss) {
        this.pss = pss;
        this.trees = pss.getTrees();
        this.elements = pss.getElements();
        this.types = pss.getTypes();
    }

    public String href(Element e) {
        return ((StringBuilder)this.visit(e)).toString();
    }

    @Override
    public StringBuilder visitType(TypeElement t, Void _) {
        ClassTree ct = this.trees.getTree(t);
        if (ct == null) {
            return null;
        }
        switch (t.getNestingKind()) {
            case ANONYMOUS: {
                String binaryName = this.elements.getBinaryName(t).toString();
                int idx = binaryName.lastIndexOf(36);
                String name = "~" + binaryName.substring(idx);
                return this.combine(this.getEnclosingTypeOrPackage(t).accept(this, null)).append(name);
            }
            case TOP_LEVEL: {
                CompilationUnitTree owner = this.pss.getTreePathByClass().get(ct).getCompilationUnit();
                String primaryTypeName = TreeUtil.getPrimaryTypeName(owner);
                String simpleName = ct.getSimpleName().toString();
                StringBuilder buf = new StringBuilder();
                if (!primaryTypeName.equals(simpleName)) {
                    buf.append("~").append(simpleName);
                }
                return buf;
            }
            case MEMBER: 
            case LOCAL: {
                return this.recurse(t).append('~').append(t.getSimpleName());
            }
        }
        throw new IllegalStateException(t.getNestingKind().toString());
    }

    private Element getEnclosingTypeOrPackage(Element e) {
        while (!((e = e.getEnclosingElement()) instanceof TypeElement) && !(e instanceof PackageElement)) {
        }
        return e;
    }

    @Override
    public StringBuilder visitVariable(VariableElement v, Void _) {
        StringBuilder buf = this.recurse(v);
        if (buf == null) {
            return null;
        }
        return buf.append(v.getSimpleName());
    }

    @Override
    public StringBuilder visitExecutable(ExecutableElement e, Void _) {
        StringBuilder buf = this.recurse(e);
        if (buf == null) {
            return null;
        }
        switch (e.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return TreeUtil.buildMethodName(buf, this.types, e);
            }
        }
        return buf.append(this.getSiblingIndex(e));
    }

    @Override
    public StringBuilder visitTypeParameter(TypeParameterElement v, Void _) {
        throw new IllegalStateException();
    }

    @Override
    public StringBuilder visitPackage(PackageElement p, Void _) {
        throw new IllegalStateException();
    }

    private StringBuilder recurse(Element e) {
        return this.combine(e.getEnclosingElement().accept(this, null));
    }

    private StringBuilder combine(StringBuilder prefix) {
        if (prefix == null) {
            return null;
        }
        int len = prefix.length();
        if (len > 0 && prefix.charAt(len - 1) == '/') {
            return prefix;
        }
        if (len > 0) {
            prefix.append('-');
        }
        return prefix;
    }

    private int getSiblingIndex(Element e) {
        int idx = e.getEnclosingElement().getEnclosedElements().indexOf(e);
        assert (idx >= 0);
        return idx;
    }
}

