/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.util.TreePath;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.jvnet.sorcerer.AbstractWriter;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.ParsedType;
import org.jvnet.sorcerer.PkgInfo;
import org.jvnet.sorcerer.util.JsonWriter;
import org.jvnet.sorcerer.util.TreeUtil;

public class ClassUsageJsWriter
extends AbstractWriter {
    public ClassUsageJsWriter(ParsedSourceSet pss) {
        super(pss);
    }

    public void write(ParsedType type, PrintWriter pw) {
        pw.println("setClassUsage('" + type.element.getQualifiedName() + "',");
        JsonWriter w = new JsonWriter(pw);
        w.startObject();
        for (Map.Entry<Element, Set<TreePath>> e : type.findReferers().entrySet()) {
            w.key(this.getKeyName(type, e.getKey()));
            NodePkgInfo root = new NodePkgInfo("");
            for (TreePath t : e.getValue()) {
                root.add(t).getLeaves().add(t);
            }
            w.object(root);
        }
        w.endObject();
        pw.println(");");
        pw.close();
    }

    protected String getKeyName(ParsedType referencedType, Element e) {
        if (((Object)e).equals(referencedType.element)) {
            return "this";
        }
        switch (e.getKind()) {
            case FIELD: 
            case ENUM_CONSTANT: {
                return e.getSimpleName().toString();
            }
            case METHOD: 
            case CONSTRUCTOR: {
                return TreeUtil.getFullMethodName(this.pss.getTypes(), (ExecutableElement)e);
            }
        }
        throw new IllegalStateException(e.toString());
    }

    ParentNode addNode(ParentNode root, TreePath t) {
        Element e;
        ParentNode p = t.getParentPath() != null ? this.addNode(root, t.getParentPath()) : root;
        if (TreeUtil.OUTLINE_WORTHY_TREE.contains((Object)t.getLeaf().getKind()) && (e = TreeUtil.getElement(t.getLeaf())) != null) {
            return p.getChildren().getOrCreate(e, t);
        }
        return p;
    }

    protected Node createNode(Element e, TreePath path) {
        return new Node(e, path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Node
    implements JsonWriter.Writable,
    ParentNode {
        final Element element;
        final TreePath path;
        final NodeMap children;
        final List<TreePath> leaves;
        boolean parentIsPackage;

        protected Node(Element element, TreePath path) {
            this.children = new NodeMap();
            this.leaves = new ArrayList<TreePath>();
            this.element = element;
            this.path = path;
        }

        @Override
        public NodeMap getChildren() {
            return this.children;
        }

        @Override
        public List<TreePath> getLeaves() {
            return this.leaves;
        }

        @Override
        public void write(JsonWriter w) {
            if (this.element != null) {
                ClassUsageJsWriter.this.writeOutlineNodeProperties(w, this.element, this.path.getCompilationUnit(), this.path.getLeaf());
            }
            if (this.parentIsPackage) {
                String name = this.element.getSimpleName().toString();
                if (!TreeUtil.getPrimaryTypeName(this.path.getCompilationUnit()).equals(name)) {
                    w.property("source", name);
                }
            }
            if (!this.children.isEmpty()) {
                w.property("children", this.children.values());
            }
            if (!this.leaves.isEmpty()) {
                w.key("leaves");
                w.startArray();
                for (TreePath p : this.leaves) {
                    long pos = ClassUsageJsWriter.this.pss.getSourcePositions().getStartPosition(p.getCompilationUnit(), p.getLeaf());
                    w.object((int)p.getCompilationUnit().getLineMap().getLineNumber(pos));
                }
                w.endArray();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodePkgInfo
    extends PkgInfo<NodePkgInfo>
    implements ParentNode {
        final NodeMap children;
        final List<TreePath> leaves;

        public NodePkgInfo(String name) {
            super(name);
            this.children = new NodeMap();
            this.leaves = new ArrayList<TreePath>();
        }

        protected ParentNode add(TreePath t) {
            NodePkgInfo leafPkg = (NodePkgInfo)super.add(TreeUtil.getPackageName(t.getCompilationUnit()));
            return ClassUsageJsWriter.this.addNode(leafPkg, t);
        }

        @Override
        public NodeMap getChildren() {
            return this.children;
        }

        @Override
        public List<TreePath> getLeaves() {
            return this.leaves;
        }

        @Override
        public NodePkgInfo create(String name) {
            return new NodePkgInfo(name);
        }

        @Override
        public void write(JsonWriter js) {
            js.property("kind", "package");
            super.write(js);
            for (Node n : this.children.values()) {
                n.parentIsPackage = true;
            }
            if (!this.children.isEmpty()) {
                js.property("classes", this.children.values());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParentNode {
        public NodeMap getChildren();

        public List<TreePath> getLeaves();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NodeMap
    extends HashMap<Element, Node> {
        private NodeMap() {
        }

        Node getOrCreate(Element e, TreePath t) {
            Node n = (Node)this.get(e);
            if (n == null) {
                n = ClassUsageJsWriter.this.createNode(e, t);
                this.put(e, n);
            }
            return n;
        }
    }
}

