/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import antlr.Token;
import antlr.TokenStreamException;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jvnet.sorcerer.JavaScriptStreamWriter;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.Tag;
import org.jvnet.sorcerer.TagScanner;
import org.jvnet.sorcerer.TagStack;
import org.jvnet.sorcerer.impl.JavaLexer;
import org.jvnet.sorcerer.util.CharSequenceReader;
import org.jvnet.sorcerer.util.TreeUtil;

final class AstGenerator {
    protected final List<Tag> tags = new ArrayList<Tag>();
    protected final CharSequence sourceFile;
    protected final ParsedSourceSet pss;
    protected final CompilationUnitTree compUnit;
    protected int lineNumber = 0;
    private String tab;
    protected final String relativeLinkToTop;

    AstGenerator(ParsedSourceSet pss, CompilationUnitTree cu) throws IOException {
        this.pss = pss;
        this.compUnit = cu;
        this.sourceFile = cu.getSourceFile().getCharContent(true);
        pss.configure(cu, this);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < pss.getTabWidth(); ++i) {
            b.append(' ');
        }
        this.tab = b.toString();
        String pkgName = TreeUtil.getPackageName(cu);
        StringBuilder buf = new StringBuilder();
        for (int i = new StringTokenizer(pkgName, ".").countTokens(); i > 0; --i) {
            buf.append("../");
        }
        this.relativeLinkToTop = buf.toString();
    }

    public void write(JavaScriptStreamWriter out) throws IOException {
        this.writeHeader(out);
        this.writeBody(out);
        this.writeFooter(out);
    }

    public void write(OutputStream os) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        this.write(new JavaScriptStreamWriter((Writer)w, this.pss));
        ((Writer)w).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File out) throws IOException {
        FileOutputStream os = new FileOutputStream(out);
        try {
            this.write(os);
        }
        finally {
            os.close();
        }
    }

    public Tag.Root buildTree() throws IOException {
        CharSequenceReader in = new CharSequenceReader(this.sourceFile);
        long curPos = 0L;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[256];
        Collections.sort(this.tags);
        TagStack opened = new TagStack();
        Tag.Root root = new Tag.Root(this.sourceFile.length());
        opened.push(root);
        TagScanner upcoming = new TagScanner(this.tags);
        block0: while (true) {
            TagStack.Adder lhs = opened.peek();
            Tag rhs = upcoming.peek();
            long nextPos = Math.min(lhs == null ? Long.MAX_VALUE : lhs.endPos(), rhs == null ? Long.MAX_VALUE : rhs.sp);
            sb.setLength(0);
            while (curPos < nextPos) {
                int sz = ((Reader)in).read(buf, 0, (int)Math.min(nextPos - curPos, (long)buf.length));
                if (sz < 0) break block0;
                sb.append(buf, 0, sz);
                curPos += (long)sz;
            }
            assert (lhs != null);
            if (sb.length() > 0) {
                lhs.add(new Tag.SourceText(curPos - (long)sb.length(), curPos, sb.toString()));
            }
            if (lhs.endPos() == nextPos) {
                opened.pop();
                continue;
            }
            lhs.add(rhs);
            opened.push(rhs);
            upcoming.pop();
        }
        while (upcoming.peek() != null) {
            Tag t = upcoming.pop();
            opened.peek().add(t);
            opened.push(t);
        }
        return root;
    }

    public void writeBody(JavaScriptStreamWriter out) throws IOException {
        Tag.Root tree = this.buildTree();
        tree.collectSymbols(out);
        out.resetList();
        out.writeSymbolTable();
        out.println();
        out.resetList();
        out.print("return ");
        tree.write(out);
    }

    protected void writeSourceCode(PrintWriter out, char[] buf, int sz) {
        block8: for (int i = 0; i < sz; ++i) {
            char ch = buf[i];
            switch (ch) {
                case '<': {
                    out.write("&lt;");
                    continue block8;
                }
                case '>': {
                    out.write("&gt;");
                    continue block8;
                }
                case '&': {
                    out.write("&amp;");
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '\n': {
                    this.writeEOL(out);
                    this.writeNewLine(out);
                    continue block8;
                }
                case '\t': {
                    out.write(this.tab);
                    continue block8;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    protected void writeEOL(PrintWriter out) {
        out.println();
    }

    protected void writeNewLine(PrintWriter out) {
        ++this.lineNumber;
    }

    protected void writeHeader(JavaScriptStreamWriter out) {
        out.println("defineStructure(");
        out.string(TreeUtil.getPrimaryTypeName(this.compUnit));
        out.print(',');
        out.print("function(factory){with(factory) { ");
        out.i().nl();
    }

    protected void writeBodyTag(PrintWriter out) {
        out.println("<body>");
    }

    protected void writeFooter(JavaScriptStreamWriter out) {
        out.o().nl().print(";}});");
    }

    boolean add(Tag o) {
        if (o.ep == -1L) {
            return false;
        }
        return this.tags.add(o);
    }

    protected final Token findTokenAfter(Tree t, boolean findAfterToken, String id) {
        long pos = findAfterToken ? this.pss.getSourcePositions().getEndPosition(this.compUnit, t) : this.pss.getSourcePositions().getStartPosition(this.compUnit, t);
        if (pos < 0L) {
            return null;
        }
        JavaLexer lexer = new JavaLexer(new CharSequenceReader(this.sourceFile.subSequence((int)pos, this.sourceFile.length())));
        lexer.setTabSize(this.pss.getTabWidth());
        try {
            Token token;
            int type;
            while ((type = (token = lexer.nextToken()).getType()) != 1) {
                if (type != 59 || id != null && !token.getText().equals(id)) continue;
                LineMap lm = this.compUnit.getLineMap();
                if (token.getLine() == 1) {
                    token.setColumn(token.getColumn() + (int)lm.getColumnNumber(pos) - 1);
                }
                token.setLine(token.getLine() + (int)lm.getLineNumber(pos) - 1);
                return token;
            }
        }
        catch (TokenStreamException e) {
            // empty catch block
        }
        return null;
    }
}

