{-# LANGUAGE ForeignFunctionInterface, CPP #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.ARB.TessellationShader
-- Copyright   :  (c) Sven Panne 2013
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All raw functions and tokens from the ARB_tessellation_shader extension, see
-- <http://www.opengl.org/registry/specs/ARB/tessellation_shader.txt>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.ARB.TessellationShader (
   -- * Functions
   glPatchParameteri,
   glPatchParameterfv,

   -- * Tokens
   gl_PATCHES,
   gl_PATCH_VERTICES,
   gl_PATCH_DEFAULT_INNER_LEVEL,
   gl_PATCH_DEFAULT_OUTER_LEVEL,
   gl_TESS_CONTROL_OUTPUT_VERTICES,
   gl_TESS_GEN_MODE,
   gl_TESS_GEN_SPACING,
   gl_TESS_GEN_VERTEX_ORDER,
   gl_TESS_GEN_POINT_MODE,
   gl_TRIANGLES,
   gl_ISOLINES,
   gl_QUADS,
   gl_EQUAL,
   gl_FRACTIONAL_ODD,
   gl_FRACTIONAL_EVEN,
   gl_CCW,
   gl_CW,
   gl_MAX_PATCH_VERTICES,
   gl_MAX_TESS_GEN_LEVEL,
   gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS,
   gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS,
   gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS,
   gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS,
   gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS,
   gl_MAX_TESS_PATCH_COMPONENTS,
   gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS,
   gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS,
   gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS,
   gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS,
   gl_MAX_TESS_CONTROL_INPUT_COMPONENTS,
   gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS,
   gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS,
   gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS,
   gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER,
   gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER,
   gl_TESS_EVALUATION_SHADER,
   gl_TESS_CONTROL_SHADER
) where

import Foreign.C.Types
import Foreign.Ptr
import Graphics.Rendering.OpenGL.Raw.ARB.Compatibility.Tokens
import Graphics.Rendering.OpenGL.Raw.Core31.Tokens
import Graphics.Rendering.OpenGL.Raw.Core31.Types
import Graphics.Rendering.OpenGL.Raw.Extensions

#include "HsOpenGLRaw.h"

extensionNameString :: String
extensionNameString = "GL_ARB_ARB_tessellation_shader"

EXTENSION_ENTRY(dyn_glPatchParameteri,ptr_glPatchParameteri,"glPatchParameteri",glPatchParameteri,GLenum -> GLint -> IO ())
EXTENSION_ENTRY(dyn_glPatchParameterfv,ptr_glPatchParameterfv,"glPatchParameterfv",glPatchParameterfv,GLenum -> Ptr GLfloat -> IO ())

gl_PATCHES :: GLenum
gl_PATCHES = 0x000E

gl_PATCH_VERTICES :: GLenum
gl_PATCH_VERTICES = 0x8E72

gl_PATCH_DEFAULT_INNER_LEVEL :: GLenum
gl_PATCH_DEFAULT_INNER_LEVEL = 0x8E73

gl_PATCH_DEFAULT_OUTER_LEVEL :: GLenum
gl_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74

gl_TESS_CONTROL_OUTPUT_VERTICES :: GLenum
gl_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75

gl_TESS_GEN_MODE :: GLenum
gl_TESS_GEN_MODE = 0x8E76

gl_TESS_GEN_SPACING :: GLenum
gl_TESS_GEN_SPACING = 0x8E77

gl_TESS_GEN_VERTEX_ORDER :: GLenum
gl_TESS_GEN_VERTEX_ORDER = 0x8E78

gl_TESS_GEN_POINT_MODE :: GLenum
gl_TESS_GEN_POINT_MODE = 0x8E79

gl_ISOLINES :: GLenum
gl_ISOLINES = 0x8E7A

gl_FRACTIONAL_ODD :: GLenum
gl_FRACTIONAL_ODD = 0x8E7B

gl_FRACTIONAL_EVEN :: GLenum
gl_FRACTIONAL_EVEN = 0x8E7C

gl_MAX_PATCH_VERTICES :: GLenum
gl_MAX_PATCH_VERTICES = 0x8E7D

gl_MAX_TESS_GEN_LEVEL :: GLenum
gl_MAX_TESS_GEN_LEVEL = 0x8E7E

gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F

gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80

gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81

gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82

gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83

gl_MAX_TESS_PATCH_COMPONENTS :: GLenum
gl_MAX_TESS_PATCH_COMPONENTS = 0x8E84

gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85

gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86

gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89

gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A

gl_MAX_TESS_CONTROL_INPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C

gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D

gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E

gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F

gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0

gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1

gl_TESS_EVALUATION_SHADER :: GLenum
gl_TESS_EVALUATION_SHADER = 0x8E87

gl_TESS_CONTROL_SHADER :: GLenum
gl_TESS_CONTROL_SHADER = 0x8E88
