---
name: Feature Request - Add new algorithm
about: Add support for new hash-mode (-m)
title: ''
labels: new algorithm
assignees: ''

---

**Is your request based on a publicly know cryptographic schema and where can we find information about?**
For instance:
- The hashing function XY is a public known hash algorithm on Wikipedia. 
- The password protection for the application XY was made by public by security researcher XY and there's a paper called ...
- The cryptographic schema used in protocol XY can be found in the OSS code on it's GitHub repository.

**Describe alternatives you've considered**
A clear and concise description of any alternative solutions or features you've considered. For instance, other standalone crackers which already support this algorithm.

**Provide an example hash/database/file and a known correct password**
The most easy way to produce this is to simply generate a new one using the application itself.

**Explain how the cryptographic schema is implemented**
The best way is with a proof of concept code in any computer language or pseudo code you like. 

**Describe the known limitations of the algorithm**
Many applications limit the password and/or salt to a specific minimum and maximum length.

**Where do you typically find the algorithm**
In case you are requesting a cryptographic primitive, name some of the Applications/OS in which it is being used.

**Additional context**
Add any other context or screenshots about the feature request here.
