/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.interfaces;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Structure;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.ReadFuture;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.ssl.SslFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpIoSession
implements IoSession {
    public static final String ATTRIBUTE_PREFIX = "org.apache.ftpserver.";
    private static final String ATTRIBUTE_USER_ARGUMENT = "org.apache.ftpserver.user-argument";
    private static final String ATTRIBUTE_USER = "org.apache.ftpserver.user";
    private static final String ATTRIBUTE_LANGUAGE = "org.apache.ftpserver.language";
    private static final String ATTRIBUTE_LOGIN_TIME = "org.apache.ftpserver.login-time";
    private static final String ATTRIBUTE_DATA_CONNECTION = "org.apache.ftpserver.data-connection";
    private static final String ATTRIBUTE_FILE_SYSTEM = "org.apache.ftpserver.file-system";
    private static final String ATTRIBUTE_RENAME_FROM = "org.apache.ftpserver.rename-from";
    private static final String ATTRIBUTE_FILE_OFFSET = "org.apache.ftpserver.file-offset";
    private static final String ATTRIBUTE_DATA_TYPE = "org.apache.ftpserver.data-type";
    private static final String ATTRIBUTE_STRUCTURE = "org.apache.ftpserver.structure";
    private static final String ATTRIBUTE_FAILED_LOGINS = "org.apache.ftpserver.failed-logins";
    private static final String ATTRIBUTE_LISTENER = "org.apache.ftpserver.listener";
    private static final Object ATTRIBUTE_MAX_IDLE_TIME = "org.apache.ftpserver.max-idle-time";
    private static final Object ATTRIBUTE_LAST_ACCESS_TIME = "org.apache.ftpserver.last-access-time";
    private IoSession wrappedSession;
    private FtpServerContext context;

    public CloseFuture close() {
        return this.wrappedSession.close();
    }

    public CloseFuture close(boolean immediately) {
        return this.wrappedSession.close(immediately);
    }

    public CloseFuture closeOnFlush() {
        return this.wrappedSession.closeOnFlush();
    }

    public boolean containsAttribute(Object key) {
        return this.wrappedSession.containsAttribute(key);
    }

    public Object getAttachment() {
        return this.wrappedSession.getAttachment();
    }

    public Object getAttribute(Object key) {
        return this.wrappedSession.getAttribute(key);
    }

    public Object getAttribute(Object key, Object defaultValue) {
        return this.wrappedSession.getAttribute(key, defaultValue);
    }

    public Set<Object> getAttributeKeys() {
        return this.wrappedSession.getAttributeKeys();
    }

    public int getBothIdleCount() {
        return this.wrappedSession.getBothIdleCount();
    }

    public CloseFuture getCloseFuture() {
        return this.wrappedSession.getCloseFuture();
    }

    public IoSessionConfig getConfig() {
        return this.wrappedSession.getConfig();
    }

    public long getCreationTime() {
        return this.wrappedSession.getCreationTime();
    }

    public IoFilterChain getFilterChain() {
        return this.wrappedSession.getFilterChain();
    }

    public IoHandler getHandler() {
        return this.wrappedSession.getHandler();
    }

    public long getId() {
        return this.wrappedSession.getId();
    }

    public int getIdleCount(IdleStatus status) {
        return this.wrappedSession.getIdleCount(status);
    }

    public long getLastBothIdleTime() {
        return this.wrappedSession.getLastBothIdleTime();
    }

    public long getLastIdleTime(IdleStatus status) {
        return this.wrappedSession.getLastIdleTime(status);
    }

    public long getLastIoTime() {
        return this.wrappedSession.getLastIoTime();
    }

    public long getLastReadTime() {
        return this.wrappedSession.getLastReadTime();
    }

    public long getLastReaderIdleTime() {
        return this.wrappedSession.getLastReaderIdleTime();
    }

    public long getLastWriteTime() {
        return this.wrappedSession.getLastWriteTime();
    }

    public long getLastWriterIdleTime() {
        return this.wrappedSession.getLastWriterIdleTime();
    }

    public SocketAddress getLocalAddress() {
        return this.wrappedSession.getLocalAddress();
    }

    public long getReadBytes() {
        return this.wrappedSession.getReadBytes();
    }

    public double getReadBytesThroughput() {
        return this.wrappedSession.getReadBytesThroughput();
    }

    public long getReadMessages() {
        return this.wrappedSession.getReadMessages();
    }

    public double getReadMessagesThroughput() {
        return this.wrappedSession.getReadMessagesThroughput();
    }

    public int getReaderIdleCount() {
        return this.wrappedSession.getReaderIdleCount();
    }

    public SocketAddress getRemoteAddress() {
        return this.wrappedSession.getRemoteAddress();
    }

    public long getScheduledWriteBytes() {
        return this.wrappedSession.getScheduledWriteBytes();
    }

    public int getScheduledWriteMessages() {
        return this.wrappedSession.getScheduledWriteMessages();
    }

    public IoService getService() {
        return this.wrappedSession.getService();
    }

    public SocketAddress getServiceAddress() {
        return this.wrappedSession.getServiceAddress();
    }

    public TrafficMask getTrafficMask() {
        return this.wrappedSession.getTrafficMask();
    }

    public TransportMetadata getTransportMetadata() {
        return this.wrappedSession.getTransportMetadata();
    }

    public int getWriterIdleCount() {
        return this.wrappedSession.getWriterIdleCount();
    }

    public long getWrittenBytes() {
        return this.wrappedSession.getWrittenBytes();
    }

    public double getWrittenBytesThroughput() {
        return this.wrappedSession.getWrittenBytesThroughput();
    }

    public long getWrittenMessages() {
        return this.wrappedSession.getWrittenMessages();
    }

    public double getWrittenMessagesThroughput() {
        return this.wrappedSession.getWrittenMessagesThroughput();
    }

    public boolean isClosing() {
        return this.wrappedSession.isClosing();
    }

    public boolean isConnected() {
        return this.wrappedSession.isConnected();
    }

    public boolean isIdle(IdleStatus status) {
        return this.wrappedSession.isIdle(status);
    }

    public ReadFuture read() {
        return this.wrappedSession.read();
    }

    public Object removeAttribute(Object key) {
        return this.wrappedSession.removeAttribute(key);
    }

    public boolean removeAttribute(Object key, Object value) {
        return this.wrappedSession.removeAttribute(key, value);
    }

    public boolean replaceAttribute(Object key, Object oldValue, Object newValue) {
        return this.wrappedSession.replaceAttribute(key, oldValue, newValue);
    }

    public void resumeRead() {
        this.wrappedSession.resumeRead();
    }

    public void resumeWrite() {
        this.wrappedSession.resumeWrite();
    }

    public Object setAttachment(Object attachment) {
        return this.wrappedSession.setAttachment(attachment);
    }

    public Object setAttribute(Object key) {
        return this.wrappedSession.setAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.wrappedSession.setAttribute(key, value);
    }

    public Object setAttributeIfAbsent(Object key) {
        return this.wrappedSession.setAttributeIfAbsent(key);
    }

    public Object setAttributeIfAbsent(Object key, Object value) {
        return this.wrappedSession.setAttributeIfAbsent(key, value);
    }

    public void setTrafficMask(TrafficMask trafficMask) {
        this.wrappedSession.setTrafficMask(trafficMask);
    }

    public void suspendRead() {
        this.wrappedSession.suspendRead();
    }

    public void suspendWrite() {
        this.wrappedSession.suspendWrite();
    }

    public WriteFuture write(Object message) {
        return this.wrappedSession.write(message);
    }

    public WriteFuture write(Object message, SocketAddress destination) {
        return this.wrappedSession.write(message, destination);
    }

    public void resetState() {
        this.removeAttribute(ATTRIBUTE_RENAME_FROM);
        this.removeAttribute(ATTRIBUTE_FILE_OFFSET);
    }

    public synchronized ServerDataConnectionFactory getDataConnection() {
        if (this.containsAttribute(ATTRIBUTE_DATA_CONNECTION)) {
            return (ServerDataConnectionFactory)this.getAttribute(ATTRIBUTE_DATA_CONNECTION);
        }
        IODataConnectionFactory dataCon = new IODataConnectionFactory(this.context, this);
        dataCon.setServerControlAddress(((InetSocketAddress)this.getLocalAddress()).getAddress());
        this.setAttribute(ATTRIBUTE_DATA_CONNECTION, dataCon);
        return dataCon;
    }

    public FileSystemView getFileSystemView() {
        return (FileSystemView)this.getAttribute(ATTRIBUTE_FILE_SYSTEM);
    }

    public User getUser() {
        return (User)this.getAttribute(ATTRIBUTE_USER);
    }

    public boolean isLoggedIn() {
        return this.containsAttribute(ATTRIBUTE_USER);
    }

    public Listener getListener() {
        return (Listener)this.getAttribute(ATTRIBUTE_LISTENER);
    }

    public void setListener(Listener listener) {
        this.setAttribute(ATTRIBUTE_LISTENER, listener);
    }

    public FtpSession getFtpletSession() {
        return new FtpSessionImpl(this);
    }

    public String getLanguage() {
        return (String)this.getAttribute(ATTRIBUTE_LANGUAGE);
    }

    public void setLanguage(String language) {
        this.setAttribute(ATTRIBUTE_LANGUAGE, language);
    }

    public String getUserArgument() {
        return (String)this.getAttribute(ATTRIBUTE_USER_ARGUMENT);
    }

    public void setUser(User user) {
        this.setAttribute(ATTRIBUTE_USER, user);
    }

    public void setUserArgument(String userArgument) {
        this.setAttribute(ATTRIBUTE_USER_ARGUMENT, userArgument);
    }

    public int getMaxIdleTime() {
        return (Integer)this.getAttribute(ATTRIBUTE_MAX_IDLE_TIME, 0);
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.setAttribute(ATTRIBUTE_MAX_IDLE_TIME, maxIdleTime);
    }

    public synchronized void increaseFailedLogins() {
        int failedLogins = (Integer)this.getAttribute(ATTRIBUTE_FAILED_LOGINS, 0);
        this.setAttribute(ATTRIBUTE_FAILED_LOGINS, ++failedLogins);
    }

    public int getFailedLogins() {
        return (Integer)this.getAttribute(ATTRIBUTE_FAILED_LOGINS, 0);
    }

    public void setLogin(FileSystemView fsview) {
        this.setAttribute(ATTRIBUTE_LOGIN_TIME, new Date());
        this.setAttribute(ATTRIBUTE_FILE_SYSTEM, fsview);
    }

    public void reinitialize() {
        this.removeAttribute(ATTRIBUTE_USER);
        this.removeAttribute(ATTRIBUTE_USER_ARGUMENT);
        this.removeAttribute(ATTRIBUTE_LOGIN_TIME);
        this.removeAttribute(ATTRIBUTE_FILE_SYSTEM);
        this.removeAttribute(ATTRIBUTE_RENAME_FROM);
        this.removeAttribute(ATTRIBUTE_FILE_OFFSET);
    }

    public void setFileOffset(long fileOffset) {
        this.setAttribute(ATTRIBUTE_FILE_OFFSET, fileOffset);
    }

    public void setRenameFrom(FileObject renFr) {
        this.setAttribute(ATTRIBUTE_RENAME_FROM, renFr);
    }

    public FileObject getRenameFrom() {
        return (FileObject)this.getAttribute(ATTRIBUTE_RENAME_FROM);
    }

    public long getFileOffset() {
        return (Long)this.getAttribute(ATTRIBUTE_FILE_OFFSET, 0L);
    }

    public void setStructure(Structure structure) {
        this.setAttribute(ATTRIBUTE_STRUCTURE, structure);
    }

    public void setDataType(DataType dataType) {
        this.setAttribute(ATTRIBUTE_DATA_TYPE, dataType);
    }

    public FtpIoSession(IoSession wrappedSession, FtpServerContext context) {
        this.wrappedSession = wrappedSession;
        this.context = context;
    }

    public Structure getStructure() {
        return (Structure)this.getAttribute(ATTRIBUTE_STRUCTURE, Structure.FILE);
    }

    public DataType getDataType() {
        return (DataType)this.getAttribute(ATTRIBUTE_DATA_TYPE, DataType.ASCII);
    }

    public Date getLoginTime() {
        return (Date)this.getAttribute(ATTRIBUTE_LOGIN_TIME);
    }

    public Date getLastAccessTime() {
        return (Date)this.getAttribute(ATTRIBUTE_LAST_ACCESS_TIME);
    }

    public Certificate[] getClientCertificates() {
        SslFilter sslFilter;
        SSLSession sslSession;
        if (this.getFilterChain().contains("sslFilter") && (sslSession = (sslFilter = (SslFilter)this.getFilterChain().get("sslFilter")).getSslSession((IoSession)this)) != null) {
            try {
                return sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }

    public void updateLastAccessTime() {
        this.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, new Date());
    }

    public Object getCurrentWriteMessage() {
        return this.wrappedSession.getCurrentWriteMessage();
    }

    public WriteRequest getCurrentWriteRequest() {
        return this.wrappedSession.getCurrentWriteRequest();
    }

    public boolean isBothIdle() {
        return this.wrappedSession.isBothIdle();
    }

    public boolean isReaderIdle() {
        return this.wrappedSession.isReaderIdle();
    }

    public boolean isWriterIdle() {
        return this.wrappedSession.isWriterIdle();
    }
}

