/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem;

import java.io.File;
import org.apache.ftpserver.filesystem.NativeFileObject;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;

public class NativeFileSystemView
implements FileSystemView {
    private String rootDir;
    private String currDir;
    private User user;
    private boolean caseInsensitive = false;

    protected NativeFileSystemView(User user) throws FtpException {
        this(user, false);
    }

    protected NativeFileSystemView(User user, boolean caseInsensitive) throws FtpException {
        if (user == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        if (user.getHomeDirectory() == null) {
            throw new IllegalArgumentException("User home directory can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        String rootDir = user.getHomeDirectory();
        if (!(rootDir = NativeFileObject.normalizeSeparateChar(rootDir)).endsWith("/")) {
            rootDir = rootDir + '/';
        }
        this.rootDir = rootDir;
        this.user = user;
        this.currDir = "/";
    }

    public FileObject getHomeDirectory() {
        return new NativeFileObject("/", new File(this.rootDir), this.user);
    }

    public FileObject getCurrentDirectory() {
        NativeFileObject fileObj = null;
        if (this.currDir.equals("/")) {
            fileObj = new NativeFileObject("/", new File(this.rootDir), this.user);
        } else {
            File file = new File(this.rootDir, this.currDir.substring(1));
            fileObj = new NativeFileObject(this.currDir, file, this.user);
        }
        return fileObj;
    }

    public FileObject getFileObject(String file) {
        String physicalName = NativeFileObject.getPhysicalName(this.rootDir, this.currDir, file);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring(this.rootDir.length() - 1);
        return new NativeFileObject(userFileName, fileObj, this.user);
    }

    public boolean changeDirectory(String dir) {
        File dirObj = new File(dir = NativeFileObject.getPhysicalName(this.rootDir, this.currDir, dir, this.caseInsensitive));
        if (!dirObj.isDirectory()) {
            return false;
        }
        if ((dir = dir.substring(this.rootDir.length() - 1)).charAt(dir.length() - 1) != '/') {
            dir = dir + '/';
        }
        this.currDir = dir;
        return true;
    }

    public boolean isRandomAccessible() {
        return true;
    }

    public void dispose() {
    }
}

