/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Set;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.DateUtils;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.StringUtils;
import org.apache.mina.common.IoSession;

public class SITE_WHO
extends AbstractCommand {
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        UserManager userManager = context.getUserManager();
        boolean isAdmin = userManager.isAdmin(session.getUser().getName());
        if (!isAdmin) {
            session.write(FtpReplyUtil.translate(session, request, context, 530, "SITE", null));
            return;
        }
        StringBuffer sb = new StringBuffer();
        Set sessions = session.getService().getManagedSessions();
        sb.append('\n');
        Iterator sessionIterator = sessions.iterator();
        while (sessionIterator.hasNext()) {
            FtpIoSession managedSession = new FtpIoSession((IoSession)sessionIterator.next(), context);
            if (!managedSession.isLoggedIn()) continue;
            User tmpUsr = managedSession.getUser();
            sb.append(StringUtils.pad(tmpUsr.getName(), ' ', true, 16));
            if (managedSession.getRemoteAddress() instanceof InetSocketAddress) {
                sb.append(StringUtils.pad(((InetSocketAddress)managedSession.getRemoteAddress()).getAddress().getHostAddress(), ' ', true, 16));
            }
            sb.append(StringUtils.pad(DateUtils.getISO8601Date(managedSession.getLoginTime().getTime()), ' ', true, 20));
            sb.append(StringUtils.pad(DateUtils.getISO8601Date(managedSession.getLastAccessTime().getTime()), ' ', true, 20));
            sb.append('\n');
        }
        sb.append('\n');
        session.write(new DefaultFtpReply(200, sb.toString()));
    }
}

