/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RNTO
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RNTO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block26: {
            try {
                FtpletEnum ftpletRet;
                String toFileStr = request.getArgument();
                if (toFileStr == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 501, "RNTO", null));
                    return;
                }
                FtpletContainer ftpletContainer = context.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onRenameStart(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
                FileObject frFile = session.getRenameFrom();
                if (frFile == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 503, "RNTO", null));
                    return;
                }
                FileObject toFile = null;
                try {
                    toFile = session.getFileSystemView().getFileObject(toFileStr);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (toFile == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 553, "RNTO.invalid", null));
                    return;
                }
                toFileStr = toFile.getFullName();
                if (!toFile.hasWritePermission()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 553, "RNTO.permission", null));
                    return;
                }
                if (!frFile.doesExist()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 553, "RNTO.missing", null));
                    return;
                }
                if (frFile.move(toFile)) {
                    session.write(FtpReplyUtil.translate(session, request, context, 250, "RNTO", toFileStr));
                    this.LOG.info("File rename (" + session.getUser().getName() + ") " + frFile.getFullName() + " -> " + toFile.getFullName());
                    try {
                        ftpletRet = ftpletContainer.onRenameEnd(session.getFtpletSession(), request);
                    }
                    catch (Exception e) {
                        this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                        ftpletRet = FtpletEnum.RET_DISCONNECT;
                    }
                    if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                        session.closeOnFlush().awaitUninterruptibly(10000L);
                        return;
                    }
                    break block26;
                }
                session.write(FtpReplyUtil.translate(session, request, context, 553, "RNTO", toFileStr));
            }
            finally {
                session.resetState();
            }
        }
    }
}

