/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RNFR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RNFR.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "RNFR", null));
            return;
        }
        FileObject renFr = null;
        try {
            renFr = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (renFr == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "RNFR", fileName));
        } else {
            session.setRenameFrom(renFr);
            fileName = renFr.getFullName();
            session.write(FtpReplyUtil.translate(session, request, context, 350, "RNFR", fileName));
        }
    }
}

