/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RMD.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        FtpletEnum ftpletRet;
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "RMD", null));
            return;
        }
        FtpletContainer ftpletContainer = context.getFtpletContainer();
        try {
            ftpletRet = ftpletContainer.onRmdirStart(session.getFtpletSession(), request);
        }
        catch (Exception e) {
            this.LOG.debug("Ftplet container threw exception", (Throwable)e);
            ftpletRet = FtpletEnum.RET_DISCONNECT;
        }
        if (ftpletRet == FtpletEnum.RET_SKIP) {
            return;
        }
        if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
            session.closeOnFlush().awaitUninterruptibly(10000L);
            return;
        }
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "RMD.permission", fileName));
            return;
        }
        fileName = file.getFullName();
        if (!file.hasDeletePermission()) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "RMD.permission", fileName));
            return;
        }
        if (!file.isDirectory()) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "RMD.invalid", fileName));
            return;
        }
        if (file.delete()) {
            session.write(FtpReplyUtil.translate(session, request, context, 250, "RMD", fileName));
            String userName = session.getUser().getName();
            this.LOG.info("Directory remove : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
            ftpStat.setRmdir(session, file);
            try {
                ftpletRet = ftpletContainer.onRmdirEnd(session.getFtpletSession(), request);
            }
            catch (Exception e) {
                this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                ftpletRet = FtpletEnum.RET_DISCONNECT;
            }
            if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                session.closeOnFlush().awaitUninterruptibly(10000L);
                return;
            }
        } else {
            session.write(FtpReplyUtil.translate(session, request, context, 450, "RMD", fileName));
        }
    }
}

