/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.example;

import org.apache.hadoop.contrib.index.mapred.DocumentID;
import org.apache.hadoop.contrib.index.mapred.IDistributionPolicy;
import org.apache.hadoop.contrib.index.mapred.Shard;

public class HashingDistributionPolicy
implements IDistributionPolicy {
    private int numShards;

    @Override
    public void init(Shard[] shards) {
        this.numShards = shards.length;
    }

    @Override
    public int chooseShardForInsert(DocumentID key) {
        int hashCode = key.hashCode();
        return hashCode >= 0 ? hashCode % this.numShards : -hashCode % this.numShards;
    }

    @Override
    public int chooseShardForDelete(DocumentID key) {
        int hashCode = key.hashCode();
        return hashCode >= 0 ? hashCode % this.numShards : -hashCode % this.numShards;
    }
}

