/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.DistributedCacheEmulator;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.GenerateDistCacheData;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobMonitor;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.SubmitterUserResolver;
import org.apache.hadoop.mapred.gridmix.Summarizer;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.ZombieJobProducer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Gridmix
extends Configured
implements Tool {
    public static final Log LOG = LogFactory.getLog(Gridmix.class);
    public static final String GRIDMIX_OUT_DIR = "gridmix.output.directory";
    public static final String GRIDMIX_SUB_THR = "gridmix.client.submit.threads";
    public static final String GRIDMIX_QUE_DEP = "gridmix.client.pending.queue.depth";
    public static final String GRIDMIX_SUB_MUL = "gridmix.submit.multiplier";
    public static final String GRIDMIX_USR_RSV = "gridmix.user.resolve.class";
    public static final String ORIGINAL_JOB_NAME = "gridmix.job.original-job-name";
    public static final String ORIGINAL_JOB_ID = "gridmix.job.original-job-id";
    private DistributedCacheEmulator distCacheEmulator;
    private JobFactory factory;
    private JobSubmitter submitter;
    private JobMonitor monitor;
    private Statistics statistics;
    private Summarizer summarizer;
    private final Shutdown sdh = new Shutdown();
    private static UserResolver userResolver;

    Gridmix(String[] args) {
        this.summarizer = new Summarizer(args);
    }

    public Gridmix() {
        this.summarizer = new Summarizer();
    }

    static Path getGridmixInputDataPath(Path ioPath) {
        return new Path(ioPath, "input");
    }

    protected void writeInputData(long genbytes, Path inputDir) throws IOException, InterruptedException {
        Configuration conf = this.getConf();
        CompressionEmulationUtil.setupDataGeneratorConfig(conf);
        GenerateData genData = new GenerateData(conf, inputDir, genbytes);
        LOG.info((Object)("Generating " + StringUtils.humanReadableInt((long)genbytes) + " of test data..."));
        this.launchGridmixJob(genData);
        FsShell shell = new FsShell(conf);
        try {
            LOG.info((Object)("Changing the permissions for inputPath " + inputDir.toString()));
            shell.run(new String[]{"-chmod", "-R", "777", inputDir.toString()});
        }
        catch (Exception e) {
            LOG.error((Object)"Couldnt change the file permissions ", (Throwable)e);
            throw new IOException(e);
        }
        LOG.info((Object)"Input data generation successful.");
    }

    protected void writeDistCacheData(Configuration conf) throws IOException, InterruptedException {
        int fileCount = conf.getInt("gridmix.distcache.file.count", -1);
        if (fileCount > 0) {
            GenerateDistCacheData genDistCacheData = new GenerateDistCacheData(conf);
            LOG.info((Object)("Generating distributed cache data of size " + conf.getLong("gridmix.distcache.byte.count", -1L)));
            this.launchGridmixJob(genDistCacheData);
        }
    }

    void launchGridmixJob(GridmixJob job) throws IOException, InterruptedException {
        this.submitter.add(job);
        TimeUnit.SECONDS.sleep(10L);
        try {
            job.getJob().waitForCompletion(false);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Internal error", e);
        }
        if (!job.getJob().isSuccessful()) {
            throw new IOException(job.getJob().getJobName() + " job failed!");
        }
    }

    protected JobStoryProducer createJobStoryProducer(String traceIn, Configuration conf) throws IOException {
        if ("-".equals(traceIn)) {
            return new ZombieJobProducer(System.in, null);
        }
        return new ZombieJobProducer(new Path(traceIn), null, conf);
    }

    protected static GridmixJobSubmissionPolicy getJobSubmissionPolicy(Configuration conf) {
        return GridmixJobSubmissionPolicy.getPolicy(conf, GridmixJobSubmissionPolicy.STRESS);
    }

    private void startThreads(Configuration conf, String traceIn, Path ioPath, Path scratchDir, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
        try {
            Path inputDir = Gridmix.getGridmixInputDataPath(ioPath);
            GridmixJobSubmissionPolicy policy = Gridmix.getJobSubmissionPolicy(conf);
            LOG.info((Object)(" Submission policy is " + policy.name()));
            this.statistics = new Statistics(conf, policy.getPollingInterval(), startFlag);
            this.monitor = this.createJobMonitor(this.statistics);
            int noOfSubmitterThreads = policy == GridmixJobSubmissionPolicy.SERIAL ? 1 : Runtime.getRuntime().availableProcessors() + 1;
            this.submitter = this.createJobSubmitter(this.monitor, conf.getInt(GRIDMIX_SUB_THR, noOfSubmitterThreads), conf.getInt(GRIDMIX_QUE_DEP, 5), new FilePool(conf, inputDir), userResolver, this.statistics);
            this.distCacheEmulator = new DistributedCacheEmulator(conf, ioPath);
            this.factory = this.createJobFactory(this.submitter, traceIn, scratchDir, conf, startFlag, userResolver);
            this.factory.jobCreator.setDistCacheEmulator(this.distCacheEmulator);
            if (policy == GridmixJobSubmissionPolicy.SERIAL) {
                this.statistics.addJobStatsListeners(this.factory);
            } else {
                this.statistics.addClusterStatsObservers(this.factory);
            }
            this.statistics.addJobStatsListeners(this.summarizer.getExecutionSummarizer());
            this.statistics.addClusterStatsObservers(this.summarizer.getClusterSummarizer());
            this.monitor.start();
            this.submitter.start();
        }
        catch (Exception e) {
            LOG.error((Object)" Exception at start ", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected JobMonitor createJobMonitor(Statistics stats) throws IOException {
        return new JobMonitor(stats);
    }

    protected JobSubmitter createJobSubmitter(JobMonitor monitor, int threads, int queueDepth, FilePool pool, UserResolver resolver, Statistics statistics) throws IOException {
        return new JobSubmitter(monitor, threads, queueDepth, pool, statistics);
    }

    protected JobFactory createJobFactory(JobSubmitter submitter, String traceIn, Path scratchDir, Configuration conf, CountDownLatch startFlag, UserResolver resolver) throws IOException {
        return GridmixJobSubmissionPolicy.getPolicy(conf, GridmixJobSubmissionPolicy.STRESS).createJobFactory(submitter, this.createJobStoryProducer(traceIn, conf), scratchDir, conf, startFlag, resolver);
    }

    public int run(final String[] argv) throws IOException, InterruptedException {
        int val = -1;
        final Configuration conf = this.getConf();
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        val = (Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return Gridmix.this.runJob(conf, argv);
            }
        });
        System.out.print("\n\n");
        System.out.println(this.summarizer.toString());
        return val;
    }

    public UserResolver getCurrentUserResolver() {
        return userResolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runJob(Configuration conf, String[] argv) throws IOException, InterruptedException {
        if (argv.length < 2) {
            this.printUsage(System.err);
            return 1;
        }
        boolean generate = false;
        long genbytes = -1L;
        String traceIn = null;
        Path ioPath = null;
        URI userRsrc = null;
        userResolver = (UserResolver)ReflectionUtils.newInstance((Class)conf.getClass(GRIDMIX_USR_RSV, SubmitterUserResolver.class, UserResolver.class), (Configuration)conf);
        try {
            for (int i = 0; i < argv.length - 2; ++i) {
                if ("-generate".equals(argv[i])) {
                    genbytes = StringUtils.TraditionalBinaryPrefix.string2long((String)argv[++i]);
                    generate = true;
                    continue;
                }
                if (!"-users".equals(argv[i])) {
                    this.printUsage(System.err);
                    return 1;
                }
                userRsrc = new URI(argv[++i]);
            }
            if (userResolver.needsTargetUsersList()) {
                if (userRsrc == null) {
                    System.err.println("\n\n" + userResolver.getClass() + " needs target user list. Use -users option." + "\n\n");
                    this.printUsage(System.err);
                    return 1;
                }
                if (!userResolver.setTargetUsers(userRsrc, conf)) {
                    LOG.warn((Object)("Ignoring the user resource '" + userRsrc + "'."));
                }
            } else if (userRsrc != null) {
                LOG.warn((Object)("Ignoring the user resource '" + userRsrc + "'."));
            }
            ioPath = new Path(argv[argv.length - 2]);
            traceIn = argv[argv.length - 1];
            return this.start(conf, traceIn, ioPath, genbytes, userResolver, generate);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsage(System.err);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int start(Configuration conf, String traceIn, Path ioPath, long genbytes, UserResolver userResolver, boolean generate) throws IOException, InterruptedException {
        Object trace;
        block18: {
            CountDownLatch startFlag;
            GenerateData.DataStatistics stats = null;
            trace = null;
            FileSystem inputFs = ioPath.getFileSystem(conf);
            ioPath = ioPath.makeQualified(inputFs);
            try {
                block15: {
                    int n;
                    block16: {
                        boolean succeeded = FileSystem.mkdirs((FileSystem)inputFs, (Path)ioPath, (FsPermission)new FsPermission(511));
                        if (!succeeded) {
                            throw new IOException("Creation of <ioPath> directory " + ioPath.toUri().toString() + " failed.");
                        }
                        Path scratchDir = new Path(ioPath, conf.get(GRIDMIX_OUT_DIR, "gridmix"));
                        Runtime.getRuntime().addShutdownHook(this.sdh);
                        startFlag = new CountDownLatch(1);
                        this.startThreads(conf, traceIn, ioPath, scratchDir, startFlag, userResolver);
                        Path inputDir = Gridmix.getGridmixInputDataPath(ioPath);
                        if (genbytes > 0L) {
                            this.writeInputData(genbytes, inputDir);
                        }
                        stats = GenerateData.publishDataStatistics(inputDir, genbytes, conf);
                        this.submitter.refreshFilePool();
                        int exitCode = this.setupEmulation(conf, traceIn, scratchDir, ioPath, generate);
                        if (exitCode == 0) break block15;
                        n = exitCode;
                        startFlag.countDown();
                        if (this.factory == null) break block16;
                        this.summarizer.finalize(this.factory, traceIn, genbytes, userResolver, stats, conf);
                    }
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{trace});
                    return n;
                }
                try {
                    this.summarizer.start(conf);
                    this.factory.start();
                    this.statistics.start();
                    break block17;
                }
                catch (Throwable e) {
                    LOG.error((Object)"Startup failed", e);
                    if (this.factory != null) {
                        this.factory.abort();
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (this.factory != null) {
                    this.summarizer.finalize(this.factory, traceIn, genbytes, userResolver, stats, conf);
                }
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{trace});
                throw throwable;
            }
            {
                block17: {
                    finally {
                        startFlag.countDown();
                    }
                }
                if (this.factory != null) {
                    this.factory.join(Long.MAX_VALUE);
                    IOException badTraceException = this.factory.error();
                    if (null != badTraceException) {
                        LOG.error((Object)"Error in trace", (Throwable)badTraceException);
                        throw new IOException("Error in trace", badTraceException);
                    }
                    this.submitter.shutdown();
                    this.submitter.join(Long.MAX_VALUE);
                    this.monitor.shutdown();
                    this.monitor.join(Long.MAX_VALUE);
                    this.statistics.shutdown();
                    this.statistics.join(Long.MAX_VALUE);
                }
                if (this.factory == null) break block18;
            }
            this.summarizer.finalize(this.factory, traceIn, genbytes, userResolver, stats, conf);
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{trace});
        return 0;
    }

    private int setupEmulation(Configuration conf, String traceIn, Path scratchDir, Path ioPath, boolean generate) throws IOException, InterruptedException {
        FileSystem scratchFs = scratchDir.getFileSystem(conf);
        FileSystem.mkdirs((FileSystem)scratchFs, (Path)scratchDir, (FsPermission)new FsPermission(511));
        return this.setupDistCacheEmulation(conf, traceIn, ioPath, generate);
    }

    private int setupDistCacheEmulation(Configuration conf, String traceIn, Path ioPath, boolean generate) throws IOException, InterruptedException {
        JobStoryProducer jsp;
        this.distCacheEmulator.init(traceIn, this.factory.jobCreator, generate);
        int exitCode = 0;
        if ((this.distCacheEmulator.shouldGenerateDistCacheData() || this.distCacheEmulator.shouldEmulateDistCacheLoad()) && (exitCode = this.distCacheEmulator.setupGenerateDistCacheData(jsp = this.createJobStoryProducer(traceIn, conf))) == 0) {
            this.writeDistCacheData(conf);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)new Configuration(), (Tool)new Gridmix(argv), (String[])argv);
        }
        finally {
            System.exit(res);
        }
    }

    private String getEnumValues(Enum<?>[] e) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Enum<?> v : e) {
            sb.append(sep);
            sb.append(v.name());
            sep = "|";
        }
        return sb.toString();
    }

    private String getJobTypes() {
        return this.getEnumValues(JobCreator.values());
    }

    private String getSubmissionPolicies() {
        return this.getEnumValues(GridmixJobSubmissionPolicy.values());
    }

    protected void printUsage(PrintStream out) {
        ToolRunner.printGenericCommandUsage((PrintStream)out);
        out.println("Usage: gridmix [-generate <MiB>] [-users URI] [-Dname=value ...] <iopath> <trace>");
        out.println("  e.g. gridmix -generate 100m foo -");
        out.println("Options:");
        out.println("   -generate <MiB> : Generate input data of size MiB under <iopath>/input/ and generate\n\t\t     distributed cache data under <iopath>/distributedCache/.");
        out.println("   -users <usersResourceURI> : URI that contains the users list.");
        out.println("Configuration parameters:");
        out.println("   General parameters:");
        out.printf("       %-48s : Output directory\n", GRIDMIX_OUT_DIR);
        out.printf("       %-48s : Submitting threads\n", GRIDMIX_SUB_THR);
        out.printf("       %-48s : Queued job desc\n", GRIDMIX_QUE_DEP);
        out.printf("       %-48s : User resolution class\n", GRIDMIX_USR_RSV);
        out.printf("       %-48s : Job types (%s)\n", "gridmix.job.type", this.getJobTypes());
        out.println("   Parameters related to job submission:");
        out.printf("       %-48s : Default queue\n", "gridmix.job-submission.default-queue");
        out.printf("       %-48s : Enable/disable using queues in trace\n", "gridmix.job-submission.use-queue-in-trace");
        out.printf("       %-48s : Job submission policy (%s)\n", "gridmix.job-submission.policy", this.getSubmissionPolicies());
        out.println("   Parameters specific for LOADJOB:");
        out.printf("       %-48s : Key fraction of rec\n", "gridmix.key.fraction");
        out.println("   Parameters specific for SLEEPJOB:");
        out.printf("       %-48s : Whether to ignore reduce tasks\n", "gridmix.sleep.maptask-only");
        out.printf("       %-48s : Number of fake locations for map tasks\n", "gridmix.sleep.fake-locations");
        out.printf("       %-48s : Maximum map task runtime in mili-sec\n", "gridmix.sleep.max-map-time");
        out.printf("       %-48s : Maximum reduce task runtime in mili-sec (merge+reduce)\n", "gridmix.sleep.max-reduce-time");
        out.println("   Parameters specific for STRESS submission throttling policy:");
        out.printf("       %-48s : jobs vs task-tracker ratio\n", "gridmix.throttle.jobs-to-tracker-ratio");
        out.printf("       %-48s : maps vs map-slot ratio\n", "gridmix.throttle.maps.task-to-slot-ratio");
        out.printf("       %-48s : reduces vs reduce-slot ratio\n", "gridmix.throttle.reduces.task-to-slot-ratio");
        out.printf("       %-48s : map-slot share per job\n", "gridmix.throttle.maps.max-slot-share-per-job");
        out.printf("       %-48s : reduce-slot share per job\n", "gridmix.throttle.reducess.max-slot-share-per-job");
    }

    static interface Component<T> {
        public void add(T var1) throws InterruptedException;

        public void start();

        public void join(long var1) throws InterruptedException;

        public void shutdown();

        public void abort();
    }

    class Shutdown
    extends Thread {
        static final long FAC_SLEEP = 1000L;
        static final long SUB_SLEEP = 4000L;
        static final long MON_SLEEP = 15000L;

        Shutdown() {
        }

        private void killComponent(Component<?> component, long maxwait) {
            if (component == null) {
                return;
            }
            component.abort();
            try {
                component.join(maxwait);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Interrupted waiting for " + component));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)"Exiting...");
            try {
                this.killComponent(Gridmix.this.factory, 1000L);
                this.killComponent(Gridmix.this.submitter, 4000L);
                this.killComponent(Gridmix.this.monitor, 15000L);
                this.killComponent(Gridmix.this.statistics, 15000L);
            }
            finally {
                if (Gridmix.this.monitor == null) {
                    return;
                }
                List<Job> remainingJobs = Gridmix.this.monitor.getRemainingJobs();
                if (remainingJobs.isEmpty()) {
                    return;
                }
                LOG.info((Object)"Killing running jobs...");
                for (Job job : remainingJobs) {
                    try {
                        if (!job.isComplete()) {
                            job.killJob();
                            LOG.info((Object)("Killed " + job.getJobName() + " (" + job.getJobID() + ")"));
                            continue;
                        }
                        if (job.isSuccessful()) {
                            Gridmix.this.monitor.onSuccess(job);
                            continue;
                        }
                        Gridmix.this.monitor.onFailure(job);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failure killing " + job.getJobName()), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Unexcpected exception", (Throwable)e);
                    }
                }
                LOG.info((Object)"Done.");
            }
        }
    }
}

