/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class JsonObjectMapperWriter<T>
implements Closeable {
    private JsonGenerator writer;

    public JsonObjectMapperWriter(OutputStream output, boolean prettyPrint) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        mapper.getJsonFactory();
        this.writer = mapper.getJsonFactory().createJsonGenerator(output, JsonEncoding.UTF8);
        if (prettyPrint) {
            this.writer.useDefaultPrettyPrinter();
        }
    }

    public void write(T object) throws IOException {
        this.writer.writeObject(object);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

