/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.stream;

import java.io.IOException;
import org.apache.mina.common.FileRegion;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.filter.stream.AbstractStreamWriteFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRegionWriteFilter
extends AbstractStreamWriteFilter<FileRegion> {
    @Override
    protected Class<FileRegion> getMessageClass() {
        return FileRegion.class;
    }

    @Override
    protected IoBuffer getNextBuffer(FileRegion fileRegion) throws IOException {
        if (fileRegion.getRemainingBytes() <= 0L) {
            return null;
        }
        int bufferSize = (int)Math.min((long)this.getWriteBufferSize(), fileRegion.getRemainingBytes());
        IoBuffer buffer = IoBuffer.allocate(bufferSize);
        int bytesRead = fileRegion.getFileChannel().read(buffer.buf(), fileRegion.getPosition());
        fileRegion.update(bytesRead);
        buffer.flip();
        return buffer;
    }
}

