/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.keepalive;

import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.DefaultWriteRequest;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.apache.mina.filter.keepalive.KeepAlivePolicy;
import org.apache.mina.filter.keepalive.KeepAliveTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveFilter
extends IoFilterAdapter {
    private final AttributeKey WAITING_FOR_RESPONSE = new AttributeKey(this.getClass(), "waitingForResponse");
    private final KeepAliveMessageFactory messageFactory;
    private final IdleStatus interestedIdleStatus;
    private volatile KeepAlivePolicy policy;
    private volatile int keepAliveRequestInterval;
    private volatile int keepAliveRequestTimeout;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public KeepAliveFilter(KeepAliveMessageFactory messageFactory) {
        this(messageFactory, IdleStatus.READER_IDLE, KeepAlivePolicy.CLOSE);
    }

    public KeepAliveFilter(KeepAliveMessageFactory messageFactory, IdleStatus interestedIdleStatus) {
        this(messageFactory, interestedIdleStatus, KeepAlivePolicy.CLOSE, 60, 30);
    }

    public KeepAliveFilter(KeepAliveMessageFactory messageFactory, KeepAlivePolicy policy) {
        this(messageFactory, IdleStatus.READER_IDLE, policy, 60, 30);
    }

    public KeepAliveFilter(KeepAliveMessageFactory messageFactory, IdleStatus interestedIdleStatus, KeepAlivePolicy policy) {
        this(messageFactory, interestedIdleStatus, policy, 60, 30);
    }

    public KeepAliveFilter(KeepAliveMessageFactory messageFactory, IdleStatus interestedIdleStatus, KeepAlivePolicy policy, int keepAliveRequestInterval, int keepAliveRequestTimeout) {
        if (messageFactory == null) {
            throw new NullPointerException("messageFactory");
        }
        if (interestedIdleStatus == null) {
            throw new NullPointerException("interestedIdleStatus");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.messageFactory = messageFactory;
        this.interestedIdleStatus = interestedIdleStatus;
        this.policy = policy;
        this.setKeepAliveRequestInterval(keepAliveRequestInterval);
        this.setKeepAliveRequestTimeout(keepAliveRequestTimeout);
    }

    public IdleStatus getInterestedIdleStatus() {
        return this.interestedIdleStatus;
    }

    public KeepAlivePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(KeepAlivePolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.policy = policy;
    }

    public int getKeepAliveRequestInterval() {
        return this.keepAliveRequestInterval;
    }

    public void setKeepAliveRequestInterval(int keepAliveRequestInterval) {
        if (keepAliveRequestInterval <= 0) {
            throw new IllegalArgumentException("keepAliveRequestInterval must be a positive integer: " + keepAliveRequestInterval);
        }
        this.keepAliveRequestInterval = keepAliveRequestInterval;
    }

    public int getKeepAliveRequestTimeout() {
        return this.keepAliveRequestTimeout;
    }

    public void setKeepAliveRequestTimeout(int keepAliveRequestTimeout) {
        if (keepAliveRequestTimeout <= 0) {
            throw new IllegalArgumentException("keepAliveRequestTimeout must be a positive integer: " + keepAliveRequestTimeout);
        }
        this.keepAliveRequestTimeout = keepAliveRequestTimeout;
    }

    public KeepAliveMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once. Create another instance and add it.");
        }
    }

    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.resetStatus(parent.getSession());
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.resetStatus(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        try {
            Object pongMessage;
            if (this.messageFactory.isRequest(session, message) && (pongMessage = this.messageFactory.getResponse(session, message)) != null) {
                nextFilter.filterWrite(session, new DefaultWriteRequest(pongMessage));
            }
            if (this.messageFactory.isResponse(session, message)) {
                this.resetStatus(session);
            }
        }
        finally {
            if (!this.isKeepAliveMessage(session, message)) {
                nextFilter.messageReceived(session, message);
            }
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (!this.isKeepAliveMessage(session, message)) {
            nextFilter.messageSent(session, writeRequest);
        }
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        block11: {
            block9: {
                block10: {
                    if (status != this.interestedIdleStatus) break block9;
                    if (session.containsAttribute(this.WAITING_FOR_RESPONSE)) break block10;
                    Object pingMessage = this.messageFactory.getRequest(session);
                    if (pingMessage != null) {
                        nextFilter.filterWrite(session, new DefaultWriteRequest(pingMessage));
                        if (this.getPolicy() != KeepAlivePolicy.OFF) {
                            this.markStatus(session);
                        } else {
                            this.resetStatus(session);
                        }
                    }
                    break block11;
                }
                this.resetStatus(session);
                switch (this.getPolicy()) {
                    case OFF: {
                        break block11;
                    }
                    case LOG: {
                        this.logTimeout();
                        break block11;
                    }
                    case EXCEPTION: {
                        throw new KeepAliveTimeoutException(this.getTimeoutMessage());
                    }
                    case CLOSE: {
                        this.logTimeout();
                        session.close();
                        break block11;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            nextFilter.sessionIdle(session, status);
        }
    }

    private void logTimeout() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.getTimeoutMessage());
        }
    }

    private String getTimeoutMessage() {
        return "Keep-alive response message was not received within " + this.getKeepAliveRequestTimeout() + " second(s).";
    }

    private void markStatus(IoSession session) {
        session.getConfig().setIdleTime(this.interestedIdleStatus, this.getKeepAliveRequestTimeout());
        session.setAttribute(this.WAITING_FOR_RESPONSE);
    }

    private void resetStatus(IoSession session) {
        session.getConfig().setIdleTime(this.interestedIdleStatus, this.getKeepAliveRequestInterval());
        session.removeAttribute(this.WAITING_FOR_RESPONSE);
    }

    private boolean isKeepAliveMessage(IoSession session, Object message) {
        return this.messageFactory.isRequest(session, message) || this.messageFactory.isResponse(session, message);
    }
}

