/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.statistics.job;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;
import org.apache.hadoop.vaidya.statistics.job.MapTaskStatistics;
import org.apache.hadoop.vaidya.statistics.job.ReduceTaskStatistics;

public class JobStatistics
implements JobStatisticsInterface {
    private static final Pattern _pattern = Pattern.compile("[[^,]?]+");
    private JobConf _jobConf;
    private JobHistory.JobInfo _jobInfo;
    private Hashtable<Enum, String> _job;
    private ArrayList<MapTaskStatistics> _mapTaskList = new ArrayList();
    private ArrayList<ReduceTaskStatistics> _reduceTaskList = new ArrayList();
    private Hashtable<Enum, ArrayList<MapTaskStatistics>> _sortedMapTaskListsByKey = new Hashtable();
    private Hashtable<Enum, ArrayList<ReduceTaskStatistics>> _sortedReduceTaskListsByKey = new Hashtable();

    void setJobConf(JobConf jobConf) {
        this._jobConf = jobConf;
    }

    @Override
    public JobConf getJobConf() {
        return this._jobConf;
    }

    @Override
    public long getLongValue(Enum key) {
        if (this._job.get(key) == null) {
            return 0L;
        }
        return Long.parseLong(this._job.get(key));
    }

    @Override
    public double getDoubleValue(Enum key) {
        if (this._job.get(key) == null) {
            return 0.0;
        }
        return Double.parseDouble(this._job.get(key));
    }

    @Override
    public String getStringValue(Enum key) {
        if (this._job.get(key) == null) {
            return "";
        }
        return this._job.get(key);
    }

    @Override
    public void setValue(Enum key, long value) {
        this._job.put(key, Long.toString(value));
    }

    @Override
    public void setValue(Enum key, double value) {
        this._job.put(key, Double.toString(value));
    }

    @Override
    public void setValue(Enum key, String value) {
        this._job.put(key, value);
    }

    public JobStatistics(JobConf jobConf, JobHistory.JobInfo jobInfo) throws ParseException {
        this._jobConf = jobConf;
        this._jobInfo = jobInfo;
        this._job = new Hashtable();
        this.populate_Job(this._job, this._jobInfo.getValues());
        this.populate_MapReduceTaskLists(this._mapTaskList, this._reduceTaskList, this._jobInfo.getAllTasks());
        if (this.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES) == 0L) {
            this._job.put(JobStatisticsInterface.JobKeys.JOBTYPE, "MAP_ONLY");
        } else {
            this._job.put(JobStatisticsInterface.JobKeys.JOBTYPE, "MAP_REDUCE");
        }
    }

    private void populate_MapReduceTaskLists(ArrayList<MapTaskStatistics> mapTaskList, ArrayList<ReduceTaskStatistics> reduceTaskList, Map<String, JobHistory.Task> taskMap) throws ParseException {
        int num_tasks = taskMap.entrySet().size();
        Iterator<Map.Entry<String, JobHistory.Task>> ti = taskMap.entrySet().iterator();
        for (int i = 0; i < num_tasks; ++i) {
            String value;
            JobHistory.Keys key;
            Iterator kv;
            int size;
            Map<JobHistory.Keys, String> successTaskAttemptMap;
            Map.Entry<String, JobHistory.Task> entry = ti.next();
            JobHistory.Task task = entry.getValue();
            if (task.get(JobHistory.Keys.TASK_TYPE).equals("MAP")) {
                MapTaskStatistics mapT = new MapTaskStatistics();
                Map mapTask = task.getValues();
                successTaskAttemptMap = this.getLastSuccessfulTaskAttempt(task);
                if (successTaskAttemptMap != null) {
                    mapTask.putAll(successTaskAttemptMap);
                } else {
                    System.err.println("Task:<" + task.get(JobHistory.Keys.TASKID) + "> is not successful - SKIPPING");
                }
                size = mapTask.size();
                kv = mapTask.entrySet().iterator();
                block32: for (int j = 0; j < size; ++j) {
                    Map.Entry mtc = kv.next();
                    key = (JobHistory.Keys)mtc.getKey();
                    value = (String)mtc.getValue();
                    switch (key) {
                        case TASKID: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.TASK_ID, value);
                            continue block32;
                        }
                        case TASK_ATTEMPT_ID: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.ATTEMPT_ID, value);
                            continue block32;
                        }
                        case HOSTNAME: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.HOSTNAME, value);
                            continue block32;
                        }
                        case TASK_TYPE: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.TASK_TYPE, value);
                            continue block32;
                        }
                        case TASK_STATUS: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.STATUS, value);
                            continue block32;
                        }
                        case START_TIME: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.START_TIME, value);
                            continue block32;
                        }
                        case FINISH_TIME: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.FINISH_TIME, value);
                            continue block32;
                        }
                        case SPLITS: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.SPLITS, value);
                            continue block32;
                        }
                        case TRACKER_NAME: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.TRACKER_NAME, value);
                            continue block32;
                        }
                        case STATE_STRING: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.STATE_STRING, value);
                            continue block32;
                        }
                        case HTTP_PORT: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.HTTP_PORT, value);
                            continue block32;
                        }
                        case ERROR: {
                            mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.ERROR, value);
                            continue block32;
                        }
                        case COUNTERS: {
                            value.concat(",");
                            this.parseAndAddMapTaskCounters(mapT, value);
                            mapTaskList.add(mapT);
                            continue block32;
                        }
                        default: {
                            System.err.println("JobHistory.MapKeys." + key + " : NOT INCLUDED IN PERFORMANCE ADVISOR MAP COUNTERS");
                        }
                    }
                }
                mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.NUM_ATTEMPTS, new Integer(task.getTaskAttempts().size()).toString());
                long etime = mapT.getLongValue(JobStatisticsInterface.MapTaskKeys.FINISH_TIME) - mapT.getLongValue(JobStatisticsInterface.MapTaskKeys.START_TIME);
                mapT.setValue((Enum)JobStatisticsInterface.MapTaskKeys.EXECUTION_TIME, new Long(etime).toString());
                continue;
            }
            if (task.get(JobHistory.Keys.TASK_TYPE).equals("REDUCE")) {
                ReduceTaskStatistics reduceT = new ReduceTaskStatistics();
                Map reduceTask = task.getValues();
                successTaskAttemptMap = this.getLastSuccessfulTaskAttempt(task);
                if (successTaskAttemptMap != null) {
                    reduceTask.putAll(successTaskAttemptMap);
                } else {
                    System.err.println("Task:<" + task.get(JobHistory.Keys.TASKID) + "> is not successful - SKIPPING");
                }
                size = reduceTask.size();
                kv = reduceTask.entrySet().iterator();
                block33: for (int j = 0; j < size; ++j) {
                    Map.Entry rtc = kv.next();
                    key = (JobHistory.Keys)rtc.getKey();
                    value = (String)rtc.getValue();
                    switch (key) {
                        case TASKID: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.TASK_ID, value);
                            continue block33;
                        }
                        case TASK_ATTEMPT_ID: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.ATTEMPT_ID, value);
                            continue block33;
                        }
                        case HOSTNAME: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.HOSTNAME, value);
                            continue block33;
                        }
                        case TASK_TYPE: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.TASK_TYPE, value);
                            continue block33;
                        }
                        case TASK_STATUS: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.STATUS, value);
                            continue block33;
                        }
                        case START_TIME: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.START_TIME, value);
                            continue block33;
                        }
                        case FINISH_TIME: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.FINISH_TIME, value);
                            continue block33;
                        }
                        case SHUFFLE_FINISHED: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.SHUFFLE_FINISH_TIME, value);
                            continue block33;
                        }
                        case SORT_FINISHED: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.SORT_FINISH_TIME, value);
                            continue block33;
                        }
                        case SPLITS: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.SPLITS, value);
                            continue block33;
                        }
                        case TRACKER_NAME: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.TRACKER_NAME, value);
                            continue block33;
                        }
                        case STATE_STRING: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.STATE_STRING, value);
                            continue block33;
                        }
                        case HTTP_PORT: {
                            reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.HTTP_PORT, value);
                            continue block33;
                        }
                        case COUNTERS: {
                            value.concat(",");
                            this.parseAndAddReduceTaskCounters(reduceT, value);
                            reduceTaskList.add(reduceT);
                            continue block33;
                        }
                        default: {
                            System.err.println("JobHistory.ReduceKeys." + key + " : NOT INCLUDED IN PERFORMANCE ADVISOR REDUCE COUNTERS");
                        }
                    }
                }
                reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.NUM_ATTEMPTS, new Integer(task.getTaskAttempts().size()).toString());
                long etime1 = reduceT.getLongValue(JobStatisticsInterface.ReduceTaskKeys.FINISH_TIME) - reduceT.getLongValue(JobStatisticsInterface.ReduceTaskKeys.START_TIME);
                reduceT.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.EXECUTION_TIME, new Long(etime1).toString());
                continue;
            }
            if (task.get(JobHistory.Keys.TASK_TYPE).equals("CLEANUP") || task.get(JobHistory.Keys.TASK_TYPE).equals("SETUP")) continue;
            System.err.println("UNKNOWN TASK TYPE : " + task.get(JobHistory.Keys.TASK_TYPE));
        }
    }

    private Map<JobHistory.Keys, String> getLastSuccessfulTaskAttempt(JobHistory.Task task) {
        Map taskAttempts = task.getTaskAttempts();
        int size = taskAttempts.size();
        Iterator kv = taskAttempts.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry tae = kv.next();
            JobHistory.TaskAttempt attempt = (JobHistory.TaskAttempt)tae.getValue();
            if (!((String)attempt.getValues().get(JobHistory.Keys.TASK_STATUS)).equals("SUCCESS")) continue;
            return attempt.getValues();
        }
        return null;
    }

    private void populate_Job(Hashtable<Enum, String> job, Map<JobHistory.Keys, String> jobC) throws ParseException {
        int size = jobC.size();
        Iterator<Map.Entry<JobHistory.Keys, String>> kv = jobC.entrySet().iterator();
        block19: for (int i = 0; i < size; ++i) {
            Map.Entry<JobHistory.Keys, String> entry = kv.next();
            JobHistory.Keys key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case JOBTRACKERID: {
                    job.put(JobStatisticsInterface.JobKeys.JOBTRACKERID, value);
                    continue block19;
                }
                case FINISH_TIME: {
                    job.put(JobStatisticsInterface.JobKeys.FINISH_TIME, value);
                    continue block19;
                }
                case JOBID: {
                    job.put(JobStatisticsInterface.JobKeys.JOBID, value);
                    continue block19;
                }
                case JOBNAME: {
                    job.put(JobStatisticsInterface.JobKeys.JOBNAME, value);
                    continue block19;
                }
                case USER: {
                    job.put(JobStatisticsInterface.JobKeys.USER, value);
                    continue block19;
                }
                case JOBCONF: {
                    job.put(JobStatisticsInterface.JobKeys.JOBCONF, value);
                    continue block19;
                }
                case SUBMIT_TIME: {
                    job.put(JobStatisticsInterface.JobKeys.SUBMIT_TIME, value);
                    continue block19;
                }
                case LAUNCH_TIME: {
                    job.put(JobStatisticsInterface.JobKeys.LAUNCH_TIME, value);
                    continue block19;
                }
                case TOTAL_MAPS: {
                    job.put(JobStatisticsInterface.JobKeys.TOTAL_MAPS, value);
                    continue block19;
                }
                case TOTAL_REDUCES: {
                    job.put(JobStatisticsInterface.JobKeys.TOTAL_REDUCES, value);
                    continue block19;
                }
                case FAILED_MAPS: {
                    job.put(JobStatisticsInterface.JobKeys.FAILED_MAPS, value);
                    continue block19;
                }
                case FAILED_REDUCES: {
                    job.put(JobStatisticsInterface.JobKeys.FAILED_REDUCES, value);
                    continue block19;
                }
                case FINISHED_MAPS: {
                    job.put(JobStatisticsInterface.JobKeys.FINISHED_MAPS, value);
                    continue block19;
                }
                case FINISHED_REDUCES: {
                    job.put(JobStatisticsInterface.JobKeys.FINISHED_REDUCES, value);
                    continue block19;
                }
                case JOB_STATUS: {
                    job.put(JobStatisticsInterface.JobKeys.STATUS, value);
                    continue block19;
                }
                case JOB_PRIORITY: {
                    job.put(JobStatisticsInterface.JobKeys.JOB_PRIORITY, value);
                    continue block19;
                }
                case COUNTERS: {
                    value.concat(",");
                    this.parseAndAddJobCounters(job, value);
                    continue block19;
                }
                default: {
                    System.err.println("JobHistory.Keys." + key + " : NOT INCLUDED IN PERFORMANCE ADVISOR COUNTERS");
                }
            }
        }
    }

    private void parseAndAddJobCounters(Hashtable<Enum, String> job, String counters) throws ParseException {
        Counters cnt = Counters.fromEscapedCompactString((String)counters);
        for (Counters.Group grp : cnt) {
            for (Counters.Counter counter : grp) {
                String countername = grp.getDisplayName() + "." + counter.getDisplayName();
                String value = new Long(counter.getValue()).toString();
                String[] parts = new String[]{countername, value};
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_READ")) {
                    job.put(JobStatisticsInterface.JobKeys.FILE_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_WRITTEN")) {
                    job.put(JobStatisticsInterface.JobKeys.FILE_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_READ")) {
                    job.put(JobStatisticsInterface.JobKeys.HDFS_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_WRITTEN")) {
                    job.put(JobStatisticsInterface.JobKeys.HDFS_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("Job Counters .Launched map tasks")) {
                    job.put(JobStatisticsInterface.JobKeys.LAUNCHED_MAPS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Job Counters .Launched reduce tasks")) {
                    job.put(JobStatisticsInterface.JobKeys.LAUNCHED_REDUCES, parts[1]);
                    continue;
                }
                if (parts[0].equals("Job Counters .Data-local map tasks")) {
                    job.put(JobStatisticsInterface.JobKeys.DATALOCAL_MAPS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Job Counters .Rack-local map tasks")) {
                    job.put(JobStatisticsInterface.JobKeys.RACKLOCAL_MAPS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map input records")) {
                    job.put(JobStatisticsInterface.JobKeys.MAP_INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map output records")) {
                    job.put(JobStatisticsInterface.JobKeys.MAP_OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map input bytes")) {
                    job.put(JobStatisticsInterface.JobKeys.MAP_INPUT_BYTES, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map output bytes")) {
                    job.put(JobStatisticsInterface.JobKeys.MAP_OUTPUT_BYTES, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine input records")) {
                    job.put(JobStatisticsInterface.JobKeys.COMBINE_INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine output records")) {
                    job.put(JobStatisticsInterface.JobKeys.COMBINE_OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce input groups")) {
                    job.put(JobStatisticsInterface.JobKeys.REDUCE_INPUT_GROUPS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce input records")) {
                    job.put(JobStatisticsInterface.JobKeys.REDUCE_INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce output records")) {
                    job.put(JobStatisticsInterface.JobKeys.REDUCE_OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Spilled Records")) {
                    job.put(JobStatisticsInterface.JobKeys.SPILLED_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce shuffle bytes")) {
                    job.put(JobStatisticsInterface.JobKeys.SHUFFLE_BYTES, parts[1]);
                    continue;
                }
                System.err.println("JobCounterKey:<" + parts[0] + "> ==> NOT INCLUDED IN PERFORMANCE ADVISOR");
            }
        }
    }

    private void parseAndAddMapTaskCounters(MapTaskStatistics mapTask, String counters) throws ParseException {
        Counters cnt = Counters.fromEscapedCompactString((String)counters);
        for (Counters.Group grp : cnt) {
            for (Counters.Counter counter : grp) {
                String countername = grp.getDisplayName() + "." + counter.getDisplayName();
                String value = new Long(counter.getValue()).toString();
                String[] parts = new String[]{countername, value};
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_READ")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.FILE_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_WRITTEN")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.FILE_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_READ")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.HDFS_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_WRITTEN")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.HDFS_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map input records")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map output records")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map input bytes")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.INPUT_BYTES, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Map output bytes")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.OUTPUT_BYTES, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine input records")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.COMBINE_INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine output records")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.COMBINE_OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Spilled Records")) {
                    mapTask.setValue((Enum)JobStatisticsInterface.MapTaskKeys.SPILLED_RECORDS, parts[1]);
                    continue;
                }
                System.err.println("MapCounterKey:<" + parts[0] + "> ==> NOT INCLUDED IN PERFORMANCE ADVISOR MAP TASK");
            }
        }
    }

    private void parseAndAddReduceTaskCounters(ReduceTaskStatistics reduceTask, String counters) throws ParseException {
        Counters cnt = Counters.fromEscapedCompactString((String)counters);
        for (Counters.Group grp : cnt) {
            for (Counters.Counter counter : grp) {
                String countername = grp.getDisplayName() + "." + counter.getDisplayName();
                String value = new Long(counter.getValue()).toString();
                String[] parts = new String[]{countername, value};
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_READ")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.FILE_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.FILE_BYTES_WRITTEN")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.FILE_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_READ")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.HDFS_BYTES_READ, parts[1]);
                    continue;
                }
                if (parts[0].equals("FileSystemCounters.HDFS_BYTES_WRITTEN")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.HDFS_BYTES_WRITTEN, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce input records")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce output records")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine input records")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.COMBINE_INPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Combine output records")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.COMBINE_OUTPUT_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce input groups")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.INPUT_GROUPS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Spilled Records")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.SPILLED_RECORDS, parts[1]);
                    continue;
                }
                if (parts[0].equals("Map-Reduce Framework.Reduce shuffle bytes")) {
                    reduceTask.setValue((Enum)JobStatisticsInterface.ReduceTaskKeys.SHUFFLE_BYTES, parts[1]);
                    continue;
                }
                System.err.println("ReduceCounterKey:<" + parts[0] + "> ==> NOT INCLUDED IN PERFORMANCE ADVISOR REDUCE TASK");
            }
        }
    }

    @Override
    public void printJobExecutionStatistics() {
        System.out.println("JOB COUNTERS *********************************************");
        int size = this._job.size();
        Iterator<Map.Entry<Enum, String>> kv = this._job.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<Enum, String> entry = kv.next();
            Enum key = entry.getKey();
            String value = entry.getValue();
            System.out.println("Key:<" + key.name() + ">, value:<" + value + ">");
        }
        System.out.println("MAP COUNTERS *********************************************");
        int size1 = this._mapTaskList.size();
        for (int i = 0; i < size1; ++i) {
            System.out.println("MAP TASK *********************************************");
            this._mapTaskList.get(i).printKeys();
        }
        System.out.println("REDUCE COUNTERS *********************************************");
        int size2 = this._mapTaskList.size();
        for (int i = 0; i < size2; ++i) {
            System.out.println("REDUCE TASK *********************************************");
            this._reduceTaskList.get(i).printKeys();
        }
    }

    @Override
    public synchronized ArrayList<MapTaskStatistics> getMapTaskList(Enum mapTaskSortKey, JobStatisticsInterface.KeyDataType dataType) {
        if (mapTaskSortKey == null) {
            mapTaskSortKey = JobStatisticsInterface.MapTaskKeys.TASK_ID;
        }
        if (this._sortedMapTaskListsByKey.get(mapTaskSortKey) == null) {
            ArrayList newList = (ArrayList)this._mapTaskList.clone();
            this._sortedMapTaskListsByKey.put(mapTaskSortKey, this.sortMapTasksByKey(newList, mapTaskSortKey, dataType));
        }
        return this._sortedMapTaskListsByKey.get(mapTaskSortKey);
    }

    private ArrayList<MapTaskStatistics> sortMapTasksByKey(ArrayList<MapTaskStatistics> mapTasks, Enum key, Enum dataType) {
        MapCounterComparator mcc = new MapCounterComparator(key, dataType);
        Collections.sort(mapTasks, mcc);
        return mapTasks;
    }

    @Override
    public synchronized ArrayList<ReduceTaskStatistics> getReduceTaskList(Enum reduceTaskSortKey, JobStatisticsInterface.KeyDataType dataType) {
        if (reduceTaskSortKey == null) {
            reduceTaskSortKey = JobStatisticsInterface.ReduceTaskKeys.TASK_ID;
        }
        if (this._sortedReduceTaskListsByKey.get(reduceTaskSortKey) == null) {
            ArrayList newList = (ArrayList)this._reduceTaskList.clone();
            this._sortedReduceTaskListsByKey.put(reduceTaskSortKey, this.sortReduceTasksByKey(newList, reduceTaskSortKey, dataType));
        }
        return this._sortedReduceTaskListsByKey.get(reduceTaskSortKey);
    }

    private ArrayList<ReduceTaskStatistics> sortReduceTasksByKey(ArrayList<ReduceTaskStatistics> reduceTasks, Enum key, Enum dataType) {
        ReduceCounterComparator rcc = new ReduceCounterComparator(key, dataType);
        Collections.sort(reduceTasks, rcc);
        return reduceTasks;
    }

    private class ReduceCounterComparator
    implements Comparator<ReduceTaskStatistics> {
        public Enum _sortKey;
        public Enum _dataType;

        public ReduceCounterComparator(Enum key, Enum dataType) {
            this._sortKey = key;
            this._dataType = dataType;
        }

        @Override
        public int compare(ReduceTaskStatistics a, ReduceTaskStatistics b) {
            if (this._dataType == JobStatisticsInterface.KeyDataType.LONG) {
                long bb;
                long aa = a.getLongValue(this._sortKey);
                if (aa < (bb = b.getLongValue(this._sortKey))) {
                    return -1;
                }
                if (aa == bb) {
                    return 0;
                }
                if (aa > bb) {
                    return 1;
                }
            } else {
                return a.getStringValue(this._sortKey).compareToIgnoreCase(b.getStringValue(this._sortKey));
            }
            return 0;
        }
    }

    private class MapCounterComparator
    implements Comparator<MapTaskStatistics> {
        public Enum _sortKey;
        public Enum _dataType;

        public MapCounterComparator(Enum key, Enum dataType) {
            this._sortKey = key;
            this._dataType = dataType;
        }

        @Override
        public int compare(MapTaskStatistics a, MapTaskStatistics b) {
            if (this._dataType == JobStatisticsInterface.KeyDataType.LONG) {
                long bb;
                long aa = a.getLongValue(this._sortKey);
                if (aa < (bb = b.getLongValue(this._sortKey))) {
                    return -1;
                }
                if (aa == bb) {
                    return 0;
                }
                if (aa > bb) {
                    return 1;
                }
            } else {
                return a.getStringValue(this._sortKey).compareToIgnoreCase(b.getStringValue(this._sortKey));
            }
            return 0;
        }
    }
}

