/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis.tests;

import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;

public class ReadingHDFSFilesAsSideEffect
extends DiagnosticTest {
    private double _impact;
    private JobStatistics _job;

    @Override
    public double evaluate(JobStatistics job) {
        this._job = job;
        double normF = this.getInputElementDoubleValue("NormalizationFactor", 2.0);
        if (job.getLongValue(JobStatisticsInterface.JobKeys.MAP_INPUT_BYTES) == 0L && job.getLongValue(JobStatisticsInterface.JobKeys.HDFS_BYTES_READ) != 0L) {
            return 1.0;
        }
        if (job.getLongValue(JobStatisticsInterface.JobKeys.HDFS_BYTES_READ) == 0L) {
            return 0.0;
        }
        this._impact = job.getLongValue(JobStatisticsInterface.JobKeys.HDFS_BYTES_READ) / job.getLongValue(JobStatisticsInterface.JobKeys.MAP_INPUT_BYTES);
        this._impact = this._impact >= normF ? 1.0 : (this._impact /= normF);
        return this._impact;
    }

    @Override
    public String getPrescription() {
        return "Map and/or Reduce tasks are reading application specific files from HDFS. Make sure the replication factor\nof these HDFS files is high enough to avoid the data reading bottleneck. Typically replication factor\ncan be square root of map/reduce tasks capacity of the allocated cluster.";
    }

    @Override
    public String getReferenceDetails() {
        String ref = "* Total HDFS Bytes read: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.HDFS_BYTES_READ) + "\n" + "* Total Map Input Bytes read: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.MAP_INPUT_BYTES) + "\n" + "* Impact: " + ReadingHDFSFilesAsSideEffect.truncate(this._impact);
        return ref;
    }
}

