/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis.tests;

import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;

public class MapsReExecutionImpact
extends DiagnosticTest {
    private double _impact;
    private JobStatistics _job;
    private long _percentMapsReExecuted;

    @Override
    public double evaluate(JobStatistics job) {
        this._job = job;
        this._impact = (job.getLongValue(JobStatisticsInterface.JobKeys.LAUNCHED_MAPS) - job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_MAPS)) / job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_MAPS);
        this._percentMapsReExecuted = Math.round(this._impact * 100.0);
        return this._impact;
    }

    @Override
    public String getPrescription() {
        return "* Need careful evaluation of why maps are re-executed. \n  * It could be due to some set of unstable cluster nodes.\n  * It could be due application specific failures.";
    }

    @Override
    public String getReferenceDetails() {
        String ref = "* Total Map Tasks: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_MAPS) + "\n" + "* Launched Map Tasks: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.LAUNCHED_MAPS) + "\n" + "* Percent Maps ReExecuted: " + this._percentMapsReExecuted + "\n" + "* Impact: " + MapsReExecutionImpact.truncate(this._impact);
        return ref;
    }
}

