/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis.tests;

import java.util.ArrayList;
import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;
import org.apache.hadoop.vaidya.statistics.job.MapTaskStatistics;

public class MapSideDiskSpill
extends DiagnosticTest {
    private double _impact;
    private JobStatistics _job;
    private long _numLocalBytesWrittenByMaps;

    @Override
    public double evaluate(JobStatistics job) {
        this._job = job;
        double normF = this.getInputElementDoubleValue("NormalizationFactor", 3.0);
        ArrayList<MapTaskStatistics> smTaskList = job.getMapTaskList(JobStatisticsInterface.MapTaskKeys.FILE_BYTES_WRITTEN, JobStatisticsInterface.KeyDataType.LONG);
        int size = smTaskList.size();
        long numLocalBytesWrittenByMaps = 0L;
        for (int i = 0; i < size; ++i) {
            numLocalBytesWrittenByMaps += ((MapTaskStatistics)smTaskList.get(i)).getLongValue(JobStatisticsInterface.MapTaskKeys.FILE_BYTES_WRITTEN);
        }
        this._numLocalBytesWrittenByMaps = numLocalBytesWrittenByMaps;
        this._impact = job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES) > 0L ? (double)((this._numLocalBytesWrittenByMaps - job.getLongValue(JobStatisticsInterface.JobKeys.MAP_OUTPUT_BYTES)) / job.getLongValue(JobStatisticsInterface.JobKeys.MAP_OUTPUT_BYTES)) : (double)(this._numLocalBytesWrittenByMaps / job.getLongValue(JobStatisticsInterface.JobKeys.MAP_OUTPUT_BYTES));
        this._impact = this._impact > normF ? 1.0 : (this._impact /= normF);
        return this._impact;
    }

    @Override
    public String getPrescription() {
        return "* Use combiner to lower the map output size.\n* Increase map side sort buffer size (io.sort.mb:" + this._job.getJobConf().getInt("io.sort.mb", 0) + ").\n" + "* Increase index buffer size (io.sort.record.percent:" + this._job.getJobConf().getInt("io.sort.record.percent", 0) + ") if number of Map Output Records are large. \n" + "* Increase (io.sort.spill.percent:" + this._job.getJobConf().getInt("io.sort.spill.percent", 0) + "), default 0.80 i.e. 80% of sort buffer size and index buffer size. \n";
    }

    @Override
    public String getReferenceDetails() {
        String ref = "* TotalMapOutputBytes: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.MAP_OUTPUT_BYTES) + "\n" + "* Total Local Bytes Written by Maps: " + this._numLocalBytesWrittenByMaps + "\n" + "* Impact: " + MapSideDiskSpill.truncate(this._impact);
        return ref;
    }
}

