/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis.tests;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;
import org.apache.hadoop.vaidya.statistics.job.ReduceTaskStatistics;

public class BalancedReducePartitioning
extends DiagnosticTest {
    private long totalReduces;
    private long busyReducers;
    private long percentReduceRecordsSize;
    private double percent;
    private double impact;
    private JobStatistics _job;

    @Override
    public double evaluate(JobStatistics jobExecutionStats) {
        this._job = jobExecutionStats;
        if (jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.JOBTYPE).equals("MAP_ONLY")) {
            this.impact = 0.0;
            return this.impact;
        }
        this.percent = this.getInputElementDoubleValue("PercentReduceRecords", 0.9);
        ArrayList<ReduceTaskStatistics> srTaskList = jobExecutionStats.getReduceTaskList(JobStatisticsInterface.ReduceTaskKeys.INPUT_RECORDS, JobStatisticsInterface.KeyDataType.LONG);
        this.percentReduceRecordsSize = (long)(this.percent * (double)jobExecutionStats.getLongValue(JobStatisticsInterface.JobKeys.REDUCE_INPUT_RECORDS));
        this.totalReduces = jobExecutionStats.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES);
        long tempReduceRecordsCount = 0L;
        this.busyReducers = 0L;
        for (int i = srTaskList.size() - 1; i > -1; --i) {
            ++this.busyReducers;
            if ((tempReduceRecordsCount += ((ReduceTaskStatistics)srTaskList.get(i)).getLongValue(JobStatisticsInterface.ReduceTaskKeys.INPUT_RECORDS)) >= this.percentReduceRecordsSize) break;
        }
        this.impact = 1.0 - (double)this.busyReducers / (double)this.totalReduces;
        return this.impact;
    }

    public void printReduceCounters(List<Hashtable<JobStatisticsInterface.ReduceTaskKeys, String>> x, JobStatisticsInterface.ReduceTaskKeys key) {
        for (int i = 0; i < x.size(); ++i) {
            System.out.println("ind:" + i + ", Value:" + x.get(i).get((Object)key) + ":");
        }
    }

    @Override
    public String getPrescription() {
        return "* Use the appropriate partitioning function\n* For streaming job consider following partitioner and hadoop config parameters\n  * org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner\n  * -jobconf stream.map.output.field.separator, -jobconf stream.num.map.output.key.fields";
    }

    @Override
    public String getReferenceDetails() {
        String ref = "* TotalReduceTasks: " + this.totalReduces + "\n" + "* BusyReduceTasks processing " + this.percent + "% of total records: " + this.busyReducers + "\n" + "* Impact: " + BalancedReducePartitioning.truncate(this.impact);
        return ref;
    }
}

