/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya;

import java.sql.Timestamp;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;
import org.apache.hadoop.vaidya.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class DiagnosticTest
implements Runnable {
    private static final double HIGHVAL = 0.99;
    private static final double MEDIUMVAL = 0.66;
    private static final double LOWVAL = 0.33;
    private JobStatistics _jobExecutionStats;
    private Element _testConfigElement;
    private double _impactLevel;
    private boolean _evaluated;
    private boolean _testPassed;

    public boolean isEvaluated() {
        return this._evaluated;
    }

    public boolean istestPassed() {
        return this._testPassed;
    }

    public void initGlobals(JobStatistics jobExecutionStats, Element testConfigElement) {
        this._jobExecutionStats = jobExecutionStats;
        this._testConfigElement = testConfigElement;
    }

    public abstract String getPrescription();

    public abstract String getReferenceDetails();

    public abstract double evaluate(JobStatistics var1);

    public String getTitle() throws Exception {
        return XMLUtils.getElementValue("Title", this._testConfigElement);
    }

    public String getDescription() throws Exception {
        return XMLUtils.getElementValue("Description", this._testConfigElement);
    }

    public double getImportance() throws Exception {
        if (XMLUtils.getElementValue("Importance", this._testConfigElement).equalsIgnoreCase("high")) {
            return 0.99;
        }
        if (XMLUtils.getElementValue("Importance", this._testConfigElement).equalsIgnoreCase("medium")) {
            return 0.66;
        }
        return 0.33;
    }

    public double getImpactLevel() throws Exception {
        if (!this.isEvaluated()) {
            throw new Exception("Test has not been evaluated");
        }
        return DiagnosticTest.truncate(this._impactLevel);
    }

    public double getSeverityLevel() throws Exception {
        return DiagnosticTest.truncate(this.getImportance() * this.getImpactLevel());
    }

    public double getSuccessThreshold() throws Exception {
        double x = Double.parseDouble(XMLUtils.getElementValue("SuccessThreshold", this._testConfigElement));
        return DiagnosticTest.truncate(x);
    }

    public Element getReportElement(Document doc, Node parent, int i) throws Exception {
        if (!this.isEvaluated()) {
            throw new Exception("Test has not been evaluated");
        }
        if (i == 0) {
            Element reportElementx = doc.createElement("JobInformationElement");
            parent.appendChild(reportElementx);
            Element itemx = doc.createElement("JobTrackerID");
            reportElementx.appendChild(itemx);
            Text valuex = doc.createTextNode(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.JOBTRACKERID));
            itemx.appendChild(valuex);
            itemx = doc.createElement("JobName");
            reportElementx.appendChild(itemx);
            valuex = doc.createTextNode(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.JOBNAME));
            itemx.appendChild(valuex);
            itemx = doc.createElement("JobType");
            reportElementx.appendChild(itemx);
            valuex = doc.createTextNode(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.JOBTYPE));
            itemx.appendChild(valuex);
            itemx = doc.createElement("User");
            reportElementx.appendChild(itemx);
            valuex = doc.createTextNode(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.USER));
            itemx.appendChild(valuex);
            itemx = doc.createElement("SubmitTime");
            reportElementx.appendChild(itemx);
            String st1 = new Timestamp(Long.parseLong(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.SUBMIT_TIME))).toString();
            valuex = doc.createTextNode(st1);
            itemx.appendChild(valuex);
            itemx = doc.createElement("LaunchTime");
            reportElementx.appendChild(itemx);
            String st2 = new Timestamp(Long.parseLong(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.LAUNCH_TIME))).toString();
            valuex = doc.createTextNode(st2);
            itemx.appendChild(valuex);
            itemx = doc.createElement("FinishTime");
            reportElementx.appendChild(itemx);
            String st3 = new Timestamp(Long.parseLong(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.FINISH_TIME))).toString();
            valuex = doc.createTextNode(st3);
            itemx.appendChild(valuex);
            itemx = doc.createElement("Status");
            reportElementx.appendChild(itemx);
            valuex = doc.createTextNode(this._jobExecutionStats.getStringValue(JobStatisticsInterface.JobKeys.STATUS));
            itemx.appendChild(valuex);
        }
        Element reportElement = doc.createElement("TestReportElement");
        parent.appendChild(reportElement);
        Element item = doc.createElement("TestTitle");
        reportElement.appendChild(item);
        Text value = doc.createTextNode(this.getTitle());
        item.appendChild(value);
        item = doc.createElement("TestDescription");
        reportElement.appendChild(item);
        value = doc.createTextNode(this.getDescription());
        item.appendChild(value);
        item = doc.createElement("TestImportance");
        reportElement.appendChild(item);
        String imp = this.getImportance() == 0.99 ? "HIGH" : (this.getImportance() == 0.66 ? "MEDIUM" : "LOW");
        value = doc.createTextNode(imp);
        item.appendChild(value);
        item = doc.createElement("TestResult");
        reportElement.appendChild(item);
        value = this._testPassed ? doc.createTextNode("NEGATIVE(PASSED)") : doc.createTextNode("POSITIVE(FAILED)");
        item.appendChild(value);
        item = doc.createElement("TestSeverity");
        reportElement.appendChild(item);
        value = doc.createTextNode("" + this.getSeverityLevel());
        item.appendChild(value);
        item = doc.createElement("ReferenceDetails");
        reportElement.appendChild(item);
        value = doc.createTextNode("" + this.getReferenceDetails());
        item.appendChild(value);
        item = doc.createElement("TestPrescription");
        String val = this.getPrescription();
        if (val == null) {
            val = XMLUtils.getElementValue("Prescription", this._testConfigElement);
        }
        reportElement.appendChild(item);
        value = doc.createTextNode("" + val);
        item.appendChild(value);
        return reportElement;
    }

    @Override
    public void run() {
        this._impactLevel = this.evaluate(this._jobExecutionStats);
        this._evaluated = true;
        try {
            this._testPassed = !(this._impactLevel >= this.getSuccessThreshold());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected long getInputElementLongValue(String elementName, long defaultValue) {
        Element inputElement = (Element)this._testConfigElement.getElementsByTagName("InputElement").item(0);
        Element prs = null;
        prs = (Element)inputElement.getElementsByTagName(elementName).item(0);
        long value = prs != null ? Long.parseLong(prs.getFirstChild().getNodeValue().trim()) : defaultValue;
        return value;
    }

    protected double getInputElementDoubleValue(String elementName, double defaultValue) {
        Element inputElement = (Element)this._testConfigElement.getElementsByTagName("InputElement").item(0);
        Element prs = null;
        prs = (Element)inputElement.getElementsByTagName(elementName).item(0);
        double value = prs != null ? Double.parseDouble(prs.getFirstChild().getNodeValue().trim()) : defaultValue;
        return value;
    }

    protected String getInputElementStringValue(String elementName, String defaultValue) {
        Element inputElement = (Element)this._testConfigElement.getElementsByTagName("InputElement").item(0);
        Element prs = null;
        prs = (Element)inputElement.getElementsByTagName(elementName).item(0);
        String value = prs != null ? prs.getFirstChild().getNodeValue().trim() : defaultValue;
        return value;
    }

    public static double truncate(double x) {
        long y = (long)(x * 100.0);
        return (double)y / 100.0;
    }
}

