/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.IOException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.LogParser;

public class SystemLogParser
extends LogParser {
    static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public SystemLogParser(String fname) {
        super(fname);
        this.dateformat = Environment.getProperty("log.system.dateformat");
        if (this.dateformat == null) {
            this.dateformat = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+(\\d+)";
        }
        if ((this.timeformat = Environment.getProperty("log.system.timeformat")) == null) {
            this.timeformat = "\\d{2}:\\d{2}:\\d{2}";
        }
    }

    @Override
    public EventRecord parseLine(String line) throws IOException {
        EventRecord retval = null;
        if (line != null) {
            String patternStr = "(" + this.dateformat + ")";
            patternStr = patternStr + "\\s+";
            patternStr = patternStr + "(" + this.timeformat + ")";
            patternStr = patternStr + "\\s+(\\S*)\\s";
            Pattern pattern = Pattern.compile(patternStr = patternStr + ":?\\s*(.+)");
            Matcher matcher = pattern.matcher(line);
            retval = matcher.find() && matcher.groupCount() >= 0 ? new EventRecord(this.hostname, this.ips, this.parseDate(matcher.group(1), matcher.group(4)), "SystemLog", "Unknown", "Unknown", matcher.group(6)) : new EventRecord();
        }
        return retval;
    }

    @Override
    protected Calendar parseDate(String strDate, String strTime) {
        Calendar retval = Calendar.getInstance();
        String[] fields = strDate.split("\\s+");
        retval.set(2, this.parseMonth(fields[0]));
        retval.set(5, Integer.parseInt(fields[1]));
        fields = strTime.split(":");
        retval.set(11, Integer.parseInt(fields[0]));
        retval.set(12, Integer.parseInt(fields[1]));
        retval.set(13, Integer.parseInt(fields[2]));
        return retval;
    }

    private int parseMonth(String month) {
        for (int i = 0; i < months.length; ++i) {
            if (!months[i].startsWith(month)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getInfo() {
        return "System Log Parser for file : " + this.file.getAbsoluteFile();
    }
}

