/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.hadoop.contrib.failmon.EventRecord;

public class SerializedRecord {
    HashMap<String, String> fields = new HashMap();
    private static DateFormat dateFormatter = DateFormat.getDateTimeInstance(1, 1);

    public SerializedRecord(EventRecord source) {
        this.fields.clear();
        for (String k : source.getMap().keySet()) {
            ArrayList<String> strs = this.getStrings(source.getMap().get(k));
            if (strs.size() == 1) {
                this.fields.put(k, strs.get(0));
                continue;
            }
            for (int i = 0; i < strs.size(); ++i) {
                this.fields.put(k + "#" + i, strs.get(i));
            }
        }
    }

    private ArrayList<String> getStrings(Object o) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.clear();
        if (o == null) {
            retval.add("null");
        } else if (o instanceof String) {
            retval.add((String)o);
        } else if (o instanceof Calendar) {
            retval.add(dateFormatter.format(((Calendar)o).getTime()));
        } else if (o instanceof InetAddress[]) {
            for (InetAddress ip : (InetAddress[])o) {
                retval.add(ip.getHostAddress());
            }
        } else if (o instanceof String[]) {
            for (String s : (String[])o) {
                retval.add(s);
            }
        } else {
            retval.add(o.toString());
        }
        return retval;
    }

    public void set(String fieldName, String fieldValue) {
        this.fields.put(fieldName, fieldValue);
    }

    public String get(String fieldName) {
        return this.fields.get(fieldName);
    }

    public static void arrangeKeys(ArrayList<String> keys) {
        SerializedRecord.move(keys, "timestamp", 0);
        SerializedRecord.move(keys, "hostname", 1);
        SerializedRecord.move(keys, "type", 2);
    }

    private static void move(ArrayList<String> keys, String key, int position) {
        int cur = keys.indexOf(key);
        if (cur == -1) {
            return;
        }
        keys.set(cur, keys.get(position));
        keys.set(position, key);
    }

    public boolean isValid() {
        return !"invalid".equalsIgnoreCase(this.fields.get("hostname"));
    }

    public String toString() {
        String retval = "";
        ArrayList<String> keys = new ArrayList<String>(this.fields.keySet());
        SerializedRecord.arrangeKeys(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String value = this.fields.get(keys.get(i));
            retval = value == null ? retval + keys.get(i) + ":\tnull\n" : retval + keys.get(i) + ":\t" + value + "\n";
        }
        return retval;
    }
}

