/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.ShellParser;

public class SensorsParser
extends ShellParser {
    @Override
    public EventRecord query(String s) throws Exception {
        StringBuffer sb = Environment.runCommand("cat sensors.out");
        EventRecord retval = new EventRecord(InetAddress.getLocalHost().getCanonicalHostName(), InetAddress.getAllByName(InetAddress.getLocalHost().getHostName()), Calendar.getInstance(), "lm-sensors", "Unknown", "sensors -A", "-");
        this.readGroup(retval, sb, "fan");
        this.readGroup(retval, sb, "in");
        this.readGroup(retval, sb, "temp");
        this.readGroup(retval, sb, "Core");
        return retval;
    }

    private EventRecord readGroup(EventRecord er, StringBuffer sb, String prefix) {
        Pattern pattern = Pattern.compile(".*(" + prefix + "\\s*\\d*)\\s*:\\s*(\\+?\\d+)", 8);
        Matcher matcher = pattern.matcher(sb);
        while (matcher.find()) {
            er.set(matcher.group(1), matcher.group(2));
        }
        return er;
    }

    @Override
    public EventRecord[] monitor() {
        EventRecord[] recs = new EventRecord[1];
        try {
            recs[0] = this.query(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recs;
    }

    @Override
    public String getInfo() {
        return "lm-sensors parser";
    }
}

