/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.LocalStore;
import org.apache.hadoop.contrib.failmon.Monitored;
import org.apache.hadoop.contrib.failmon.ParseState;
import org.apache.hadoop.contrib.failmon.PersistentState;

public abstract class LogParser
implements Monitored {
    File file;
    BufferedReader reader;
    String hostname;
    Object[] ips;
    String dateformat;
    String timeformat;
    private String firstLine;
    private long offset;

    public LogParser(String fname) {
        this.file = new File(fname);
        ParseState ps = PersistentState.getState(this.file.getAbsolutePath());
        this.firstLine = ps.firstLine;
        this.offset = ps.offset;
        try {
            this.reader = new BufferedReader(new FileReader(this.file));
            this.checkForRotation();
            Environment.logInfo("Checked for rotation...");
            this.reader.skip(this.offset);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        this.setNetworkProperties();
    }

    protected void setNetworkProperties() {
        try {
            this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
            this.ips = InetAddress.getAllByName(this.hostname);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void monitor(LocalStore ls) {
        boolean in = false;
        EventRecord er = null;
        Environment.logInfo("Started processing log...");
        while ((er = this.getNext()) != null) {
            if (!er.isValid()) continue;
            ls.insert(er);
        }
        PersistentState.updateState(this.file.getAbsolutePath(), this.firstLine, this.offset);
        PersistentState.writeState("conf/parsing.state");
    }

    @Override
    public EventRecord[] monitor() {
        EventRecord er;
        ArrayList<EventRecord> recs = new ArrayList<EventRecord>();
        while ((er = this.getNext()) != null) {
            recs.add(er);
        }
        EventRecord[] T = new EventRecord[recs.size()];
        return recs.toArray(T);
    }

    public EventRecord getNext() {
        try {
            String line = this.reader.readLine();
            if (line != null) {
                if (this.firstLine == null) {
                    this.firstLine = new String(line);
                }
                this.offset += (long)(line.length() + 1);
                return this.parseLine(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public void checkForRotation() {
        try {
            BufferedReader probe = new BufferedReader(new FileReader(this.file.getAbsoluteFile()));
            if (this.firstLine == null || !this.firstLine.equals(probe.readLine())) {
                probe.close();
                this.reader.close();
                this.reader = new BufferedReader(new FileReader(this.file.getAbsoluteFile()));
                this.firstLine = null;
                this.offset = 0L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract EventRecord parseLine(String var1) throws IOException;

    protected abstract Calendar parseDate(String var1, String var2);
}

