/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.SerializedRecord;

public class Anonymizer {
    public static SerializedRecord anonymize(SerializedRecord sr) throws Exception {
        String hostname = sr.get("hostname");
        if (hostname == null) {
            throw new Exception("Malformed SerializedRecord: no hostname found");
        }
        if ("true".equalsIgnoreCase(Environment.getProperty("anonymizer.hash.hostnames"))) {
            Anonymizer.anonymizeField(sr, "message", hostname, "_hn_");
            Anonymizer.anonymizeField(sr, "hostname", hostname, "_hn_");
            String suffix = Environment.getProperty("anonymizer.hostname.suffix");
            if (suffix != null) {
                Anonymizer.anonymizeField(sr, "message", "(\\S+\\.)*" + suffix, "_hn_");
            }
        }
        if ("true".equalsIgnoreCase(Environment.getProperty("anonymizer.hash.ips"))) {
            String ipPattern = "(\\d{1,3}\\.){3}\\d{1,3}";
            Anonymizer.anonymizeField(sr, "message", ipPattern, "_ip_");
            Anonymizer.anonymizeField(sr, "ips", ipPattern, "_ip_");
            int i = 0;
            while (sr.get("ips#" + i) != null) {
                Anonymizer.anonymizeField(sr, "ips#" + i++, ipPattern, "_ip_");
            }
            if ("NIC".equalsIgnoreCase(sr.get("type"))) {
                Anonymizer.anonymizeField(sr, "ipAddress", ipPattern, "_ip_");
            }
        }
        if ("true".equalsIgnoreCase(Environment.getProperty("anonymizer.hash.filenames"))) {
            Anonymizer.anonymizeField(sr, "message", "\\s+/(\\S+/)*[^:\\s]*", " _fn_");
            Anonymizer.anonymizeField(sr, "message", "\\s+hdfs://(\\S+/)*[^:\\s]*", " hdfs://_fn_");
        }
        return sr;
    }

    public static SerializedRecord anonymize(EventRecord er) throws Exception {
        return Anonymizer.anonymize(new SerializedRecord(er));
    }

    private static String anonymizeField(SerializedRecord sr, String fieldName, String pattern, String prefix) {
        String txt = sr.get(fieldName);
        if (txt == null) {
            return null;
        }
        String anon = Anonymizer.getMD5Hash(pattern);
        sr.set(fieldName, txt.replaceAll(pattern, (prefix == null ? "" : prefix) + anon));
        return txt;
    }

    public static String getMD5Hash(String text) {
        byte[] md5hash = new byte[32];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            md5hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Anonymizer.convertToHex(md5hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

