/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class ProxyFilter
implements Filter {
    public static final Log LOG = LogFactory.getLog(ProxyFilter.class);
    protected static final Pattern RELOAD_PATTERN = Pattern.compile("^(/reloadPermFiles)$");
    protected static final Pattern HFTP_PATTERN = Pattern.compile("^(/listPaths|/data|/streamFile|/file)$");
    protected static final Pattern FILEPATH_PATTERN = Pattern.compile("^(/listPaths|/data|/file)$");
    private static volatile Map<String, Set<Path>> permsMap;
    private static volatile Map<String, Set<BigInteger>> certsMap;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        Configuration conf = new Configuration(false);
        conf.addResource("hdfsproxy-default.xml");
        conf.addResource("ssl-server.xml");
        conf.addResource("hdfsproxy-site.xml");
        String nn = conf.get("hdfsproxy.dfs.namenode.address");
        if (nn == null) {
            throw new ServletException("Proxy source cluster name node address not speficied");
        }
        InetSocketAddress nAddr = NetUtils.createSocketAddr((String)nn);
        context.setAttribute("name.node.address", (Object)nAddr);
        context.setAttribute("name.conf", (Object)new Configuration());
        context.setAttribute("org.apache.hadoop.hdfsproxy.conf", (Object)conf);
        LOG.info((Object)("proxyFilter initialization success: " + nn));
    }

    private static Map<String, Set<Path>> getPermMap(Configuration conf) {
        String permLoc = conf.get("hdfsproxy.user.permissions.file.location", "user-permissions.xml");
        if (conf.getResource(permLoc) == null) {
            LOG.warn((Object)"HdfsProxy user permissions file not found");
            return null;
        }
        Configuration permConf = new Configuration(false);
        permConf.addResource(permLoc);
        HashMap<String, Set<Path>> map = new HashMap<String, Set<Path>>();
        for (Map.Entry e : permConf) {
            String[] paths;
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            if (k == null || k.length() == 0 || v == null || v.length() == 0) continue;
            HashSet<Path> pathSet = new HashSet<Path>();
            for (String p : paths = v.split(",\\s*")) {
                if (p.length() == 0) continue;
                pathSet.add(new Path(p));
            }
            map.put(k, pathSet);
        }
        return map;
    }

    private static Map<String, Set<BigInteger>> getCertsMap(Configuration conf) {
        String certsLoc = conf.get("hdfsproxy.user.certs.file.location", "user-certs.xml");
        if (conf.getResource(certsLoc) == null) {
            LOG.warn((Object)"HdfsProxy user certs file not found");
            return null;
        }
        Configuration certsConf = new Configuration(false);
        certsConf.addResource(certsLoc);
        HashMap<String, Set<BigInteger>> map = new HashMap<String, Set<BigInteger>>();
        for (Map.Entry e : certsConf) {
            String[] serialnumbers;
            String k = (String)e.getKey();
            String v = ((String)e.getValue()).trim();
            if (k == null || k.length() == 0 || v == null || v.length() == 0) continue;
            HashSet<BigInteger> numSet = new HashSet<BigInteger>();
            for (String num : serialnumbers = v.split("\\s*,\\s*")) {
                if (num.length() == 0) continue;
                numSet.add(new BigInteger(num, 16));
            }
            map.put(k, numSet);
        }
        return map;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String ugi;
        HttpServletRequest rqst = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        if (LOG.isDebugEnabled()) {
            StringBuilder b = new StringBuilder("Request from ").append(rqst.getRemoteHost()).append("/").append(rqst.getRemoteAddr()).append(":").append(rqst.getRemotePort());
            Enumeration e = rqst.getAttributeNames();
            while (e.hasMoreElements()) {
                String attribute = (String)e.nextElement();
                b.append("\n  " + attribute + " => " + rqst.getAttribute(attribute));
            }
            X509Certificate[] userCerts = (X509Certificate[])rqst.getAttribute("javax.servlet.request.X509Certificate");
            if (userCerts != null) {
                for (X509Certificate cert : userCerts) {
                    b.append("\n Client certificate Subject Name is " + cert.getSubjectX500Principal().getName());
                }
            }
            b.append("\n The Scheme is " + rqst.getScheme());
            b.append("\n The Auth Type is " + rqst.getAuthType());
            b.append("\n The Path Info is " + rqst.getPathInfo());
            b.append("\n The Translated Path Info is " + rqst.getPathTranslated());
            b.append("\n The Context Path is " + rqst.getContextPath());
            b.append("\n The Query String is " + rqst.getQueryString());
            b.append("\n The Remote User is " + rqst.getRemoteUser());
            b.append("\n The User Principal is " + rqst.getUserPrincipal());
            b.append("\n The Request URI is " + rqst.getRequestURI());
            b.append("\n The Request URL is " + rqst.getRequestURL());
            b.append("\n The Servlet Path is " + rqst.getServletPath());
            LOG.debug((Object)b.toString());
        }
        boolean unitTest = false;
        if (rqst.getScheme().equalsIgnoreCase("http") && rqst.getParameter("UnitTest") != null) {
            unitTest = true;
        }
        if (rqst.getScheme().equalsIgnoreCase("https") || unitTest) {
            boolean isAuthorized = false;
            X509Certificate[] certs = (X509Certificate[])rqst.getAttribute("javax.servlet.request.X509Certificate");
            if (unitTest) {
                try {
                    X509Certificate cert;
                    LOG.debug((Object)"==> Entering https unit test");
                    String SslPath = rqst.getParameter("SslPath");
                    FileInputStream inStream = new FileInputStream(SslPath);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)cf.generateCertificate(inStream);
                    ((InputStream)inStream).close();
                    certs = new X509Certificate[]{cert};
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (certs == null || certs.length == 0) {
                rsp.sendError(400, "No client SSL certificate received");
                LOG.info((Object)"No Client SSL certificate received");
                return;
            }
            for (X509Certificate cert : certs) {
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    LOG.info((Object)("Received cert for " + cert.getSubjectX500Principal().getName() + " expired"));
                    rsp.sendError(403, "Certificate expired");
                    return;
                }
                catch (CertificateNotYetValidException e) {
                    LOG.info((Object)("Received cert for " + cert.getSubjectX500Principal().getName() + " is not yet valid"));
                    rsp.sendError(403, "Certificate is not yet valid");
                    return;
                }
            }
            String[] tokens = certs[0].getSubjectX500Principal().getName().split("\\s*,\\s*");
            String userID = null;
            for (String s : tokens) {
                if (!s.startsWith("CN=")) continue;
                userID = s;
                break;
            }
            if (userID == null || userID.length() < 4) {
                LOG.info((Object)"Can't retrieve user ID from SSL certificate");
                rsp.sendError(403, "Can't retrieve user ID from SSL certificate");
                return;
            }
            userID = userID.substring(3);
            String servletPath = rqst.getServletPath();
            if (unitTest) {
                servletPath = rqst.getParameter("TestSevletPathInfo");
                LOG.info((Object)"this is for unit test purpose only");
            }
            if (HFTP_PATTERN.matcher(servletPath).matches()) {
                isAuthorized = FILEPATH_PATTERN.matcher(servletPath).matches() ? this.checkPath(userID, certs[0], rqst.getPathInfo() != null ? rqst.getPathInfo() : "/") : this.checkPath(userID, certs[0], rqst.getParameter("filename"));
            } else if (RELOAD_PATTERN.matcher(servletPath).matches() && this.checkUser("Admin", certs[0])) {
                Configuration conf = new Configuration(false);
                conf.addResource("hdfsproxy-default.xml");
                Map<String, Set<Path>> permsMap = ProxyFilter.getPermMap(conf);
                Map<String, Set<BigInteger>> certsMap = ProxyFilter.getCertsMap(conf);
                if (permsMap == null || certsMap == null) {
                    LOG.warn((Object)"Permission files reloading failed");
                    rsp.sendError(500, "Permission files reloading failed");
                    return;
                }
                ProxyFilter.permsMap = permsMap;
                ProxyFilter.certsMap = certsMap;
                LOG.info((Object)"User permissions and user certs files reloaded");
                rsp.setStatus(200);
                return;
            }
            if (!isAuthorized) {
                rsp.sendError(403, "Unauthorized access");
                return;
            }
            UserGroupInformation ugi2 = UserGroupInformation.createRemoteUser((String)userID);
            rqst.setAttribute("authorized.ugi", (Object)ugi2);
            rqst.setAttribute("org.apache.hadoop.hdfsproxy.authorized.userID", (Object)userID);
        } else if (rqst.getScheme().equalsIgnoreCase("http") && (ugi = rqst.getParameter("ugi")) != null) {
            rqst.setAttribute("authorized.ugi", (Object)UserGroupInformation.createRemoteUser((String)ugi));
            rqst.setAttribute("org.apache.hadoop.hdfsproxy.authorized.userID", (Object)ugi.split(",")[0]);
        }
        chain.doFilter(request, response);
    }

    private boolean checkUser(String userID, X509Certificate cert) {
        Set<BigInteger> numSet = certsMap.get(userID);
        if (numSet == null) {
            LOG.info((Object)("User " + userID + " is not configured in the user certs file"));
            return false;
        }
        if (!numSet.contains(cert.getSerialNumber())) {
            LOG.info((Object)("Cert with serial number " + cert.getSerialNumber() + " is not listed for user " + userID));
            return false;
        }
        return true;
    }

    private boolean checkPath(String userID, X509Certificate cert, String pathInfo) {
        if (!this.checkUser(userID, cert)) {
            return false;
        }
        Set<Path> pathSet = permsMap.get(userID);
        if (pathSet == null) {
            LOG.info((Object)("User " + userID + " is not listed in the user permissions file"));
            return false;
        }
        if (pathInfo == null || pathInfo.length() == 0) {
            LOG.info((Object)("Can't get file path from HTTPS request; user is " + userID));
            return false;
        }
        for (Path userPath = new Path(pathInfo); userPath != null; userPath = userPath.getParent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\n Checking file path " + userPath));
            }
            if (!pathSet.contains(userPath)) continue;
            return true;
        }
        LOG.info((Object)("User " + userID + " is not authorized to access " + pathInfo));
        return false;
    }

    static {
        Configuration conf = new Configuration(false);
        conf.addResource("hdfsproxy-default.xml");
        HashMap pMap = ProxyFilter.getPermMap(conf);
        permsMap = pMap != null ? pMap : new HashMap();
        HashMap cMap = ProxyFilter.getCertsMap(conf);
        certsMap = cMap != null ? cMap : new HashMap();
    }
}

