/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class TSimpleJSONProtocol
extends TProtocol {
    public static final byte[] COMMA = new byte[]{44};
    public static final byte[] COLON = new byte[]{58};
    public static final byte[] LBRACE = new byte[]{123};
    public static final byte[] RBRACE = new byte[]{125};
    public static final byte[] LBRACKET = new byte[]{91};
    public static final byte[] RBRACKET = new byte[]{93};
    public static final char QUOTE = '\"';
    protected final Context BASE_CONTEXT = new Context();
    protected Stack<Context> writeContextStack_ = new Stack();
    protected Context writeContext_ = this.BASE_CONTEXT;

    protected void pushWriteContext(Context context) {
        this.writeContextStack_.push(this.writeContext_);
        this.writeContext_ = context;
    }

    protected void popWriteContext() {
        this.writeContext_ = this.writeContextStack_.pop();
    }

    public TSimpleJSONProtocol(TTransport tTransport) {
        super(tTransport);
    }

    @Override
    public void writeMessageBegin(TMessage tMessage) throws TException {
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
        this.writeString(tMessage.name);
        this.writeByte(tMessage.type);
        this.writeI32(tMessage.seqid);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeStructBegin(TStruct tStruct) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new StructContext());
    }

    @Override
    public void writeStructEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeFieldBegin(TField tField) throws TException {
        this.writeString(tField.name);
    }

    @Override
    public void writeFieldEnd() {
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap tMap) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new StructContext());
    }

    @Override
    public void writeMapEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeListBegin(TList tList) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeListEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeSetBegin(TSet tSet) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeSetEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeBool(boolean bl) throws TException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte by) throws TException {
        this.writeI32(by);
    }

    @Override
    public void writeI16(short s) throws TException {
        this.writeI32(s);
    }

    @Override
    public void writeI32(int n) throws TException {
        this.writeContext_.write();
        this._writeStringData(Integer.toString(n));
    }

    public void _writeStringData(String string) throws TException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.trans_.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public void writeI64(long l) throws TException {
        this.writeContext_.write();
        this._writeStringData(Long.toString(l));
    }

    @Override
    public void writeDouble(double d) throws TException {
        this.writeContext_.write();
        this._writeStringData(Double.toString(d));
    }

    @Override
    public void writeString(String string) throws TException {
        this.writeContext_.write();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        stringBuffer.append('\"');
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\b': {
                    stringBuffer.append('\\');
                    stringBuffer.append('b');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        for (int j = 4; j > string2.length(); --j) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        this._writeStringData(stringBuffer.toString());
    }

    @Override
    public void writeBinary(byte[] byArray) throws TException {
        try {
            this.writeString(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        TMessage tMessage = new TMessage();
        return tMessage;
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public TStruct readStructBegin() {
        return new TStruct();
    }

    @Override
    public void readStructEnd() {
    }

    @Override
    public TField readFieldBegin() throws TException {
        TField tField = new TField();
        return tField;
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public TMap readMapBegin() throws TException {
        TMap tMap = new TMap();
        return tMap;
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public TList readListBegin() throws TException {
        TList tList = new TList();
        return tList;
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public TSet readSetBegin() throws TException {
        TSet tSet = new TSet();
        return tSet;
    }

    @Override
    public void readSetEnd() {
    }

    @Override
    public boolean readBool() throws TException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws TException {
        return 0;
    }

    @Override
    public short readI16() throws TException {
        return 0;
    }

    @Override
    public int readI32() throws TException {
        return 0;
    }

    @Override
    public long readI64() throws TException {
        return 0L;
    }

    @Override
    public double readDouble() throws TException {
        return 0.0;
    }

    @Override
    public String readString() throws TException {
        return "";
    }

    public String readStringBody(int n) throws TException {
        return "";
    }

    @Override
    public byte[] readBinary() throws TException {
        return new byte[0];
    }

    protected class StructContext
    extends Context {
        protected boolean first_;
        protected boolean colon_;

        protected StructContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TSimpleJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }
    }

    protected class ListContext
    extends Context {
        protected boolean first_;

        protected ListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TSimpleJSONProtocol.this.trans_.write(COMMA);
            }
        }
    }

    protected class Context {
        protected Context() {
        }

        protected void write() throws TException {
        }
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport tTransport) {
            return new TSimpleJSONProtocol(tTransport);
        }
    }
}

