/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import java.io.UnsupportedEncodingException;

public class TBinaryProtocol
extends TProtocol {
    protected static final int VERSION_MASK = -65536;
    protected static final int VERSION_1 = -2147418112;
    protected boolean strictRead_ = false;
    protected boolean strictWrite_ = true;
    protected int readLength_;
    protected boolean checkReadLength_ = false;
    private byte[] bout = new byte[1];
    private byte[] i16out = new byte[2];
    private byte[] i32out = new byte[4];
    private byte[] i64out = new byte[8];
    private byte[] bin = new byte[1];
    private byte[] i16rd = new byte[2];
    private byte[] i32rd = new byte[4];
    private byte[] i64rd = new byte[8];

    public TBinaryProtocol(TTransport tTransport) {
        this(tTransport, false, true);
    }

    public TBinaryProtocol(TTransport tTransport, boolean bl, boolean bl2) {
        super(tTransport);
        this.strictRead_ = bl;
        this.strictWrite_ = bl2;
    }

    @Override
    public void writeMessageBegin(TMessage tMessage) throws TException {
        if (this.strictWrite_) {
            int n = 0x80010000 | tMessage.type;
            this.writeI32(n);
            this.writeString(tMessage.name);
            this.writeI32(tMessage.seqid);
        } else {
            this.writeString(tMessage.name);
            this.writeByte(tMessage.type);
            this.writeI32(tMessage.seqid);
        }
    }

    @Override
    public void writeMessageEnd() {
    }

    @Override
    public void writeStructBegin(TStruct tStruct) {
    }

    @Override
    public void writeStructEnd() {
    }

    @Override
    public void writeFieldBegin(TField tField) throws TException {
        this.writeByte(tField.type);
        this.writeI16(tField.id);
    }

    @Override
    public void writeFieldEnd() {
    }

    @Override
    public void writeFieldStop() throws TException {
        this.writeByte((byte)0);
    }

    @Override
    public void writeMapBegin(TMap tMap) throws TException {
        this.writeByte(tMap.keyType);
        this.writeByte(tMap.valueType);
        this.writeI32(tMap.size);
    }

    @Override
    public void writeMapEnd() {
    }

    @Override
    public void writeListBegin(TList tList) throws TException {
        this.writeByte(tList.elemType);
        this.writeI32(tList.size);
    }

    @Override
    public void writeListEnd() {
    }

    @Override
    public void writeSetBegin(TSet tSet) throws TException {
        this.writeByte(tSet.elemType);
        this.writeI32(tSet.size);
    }

    @Override
    public void writeSetEnd() {
    }

    @Override
    public void writeBool(boolean bl) throws TException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte by) throws TException {
        this.bout[0] = by;
        this.trans_.write(this.bout, 0, 1);
    }

    @Override
    public void writeI16(short s) throws TException {
        this.i16out[0] = (byte)(0xFF & s >> 8);
        this.i16out[1] = (byte)(0xFF & s);
        this.trans_.write(this.i16out, 0, 2);
    }

    @Override
    public void writeI32(int n) throws TException {
        this.i32out[0] = (byte)(0xFF & n >> 24);
        this.i32out[1] = (byte)(0xFF & n >> 16);
        this.i32out[2] = (byte)(0xFF & n >> 8);
        this.i32out[3] = (byte)(0xFF & n);
        this.trans_.write(this.i32out, 0, 4);
    }

    @Override
    public void writeI64(long l) throws TException {
        this.i64out[0] = (byte)(0xFFL & l >> 56);
        this.i64out[1] = (byte)(0xFFL & l >> 48);
        this.i64out[2] = (byte)(0xFFL & l >> 40);
        this.i64out[3] = (byte)(0xFFL & l >> 32);
        this.i64out[4] = (byte)(0xFFL & l >> 24);
        this.i64out[5] = (byte)(0xFFL & l >> 16);
        this.i64out[6] = (byte)(0xFFL & l >> 8);
        this.i64out[7] = (byte)(0xFFL & l);
        this.trans_.write(this.i64out, 0, 8);
    }

    @Override
    public void writeDouble(double d) throws TException {
        this.writeI64(Double.doubleToLongBits(d));
    }

    @Override
    public void writeString(String string) throws TException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.writeI32(byArray.length);
            this.trans_.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public void writeBinary(byte[] byArray) throws TException {
        this.writeI32(byArray.length);
        this.trans_.write(byArray, 0, byArray.length);
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        TMessage tMessage = new TMessage();
        int n = this.readI32();
        if (n < 0) {
            int n2 = n & 0xFFFF0000;
            if (n2 != -2147418112) {
                throw new TProtocolException(4, "Bad version in readMessageBegin");
            }
            tMessage.type = (byte)(n & 0xFF);
            tMessage.name = this.readString();
            tMessage.seqid = this.readI32();
        } else {
            if (this.strictRead_) {
                throw new TProtocolException(4, "Missing version in readMessageBegin, old client?");
            }
            tMessage.name = this.readStringBody(n);
            tMessage.type = this.readByte();
            tMessage.seqid = this.readI32();
        }
        return tMessage;
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public TStruct readStructBegin() {
        return new TStruct();
    }

    @Override
    public void readStructEnd() {
    }

    @Override
    public TField readFieldBegin() throws TException {
        TField tField = new TField();
        tField.type = this.readByte();
        if (tField.type != 0) {
            tField.id = this.readI16();
        }
        return tField;
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public TMap readMapBegin() throws TException {
        TMap tMap = new TMap();
        tMap.keyType = this.readByte();
        tMap.valueType = this.readByte();
        tMap.size = this.readI32();
        return tMap;
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public TList readListBegin() throws TException {
        TList tList = new TList();
        tList.elemType = this.readByte();
        tList.size = this.readI32();
        return tList;
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public TSet readSetBegin() throws TException {
        TSet tSet = new TSet();
        tSet.elemType = this.readByte();
        tSet.size = this.readI32();
        return tSet;
    }

    @Override
    public void readSetEnd() {
    }

    @Override
    public boolean readBool() throws TException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws TException {
        this.readAll(this.bin, 0, 1);
        return this.bin[0];
    }

    @Override
    public short readI16() throws TException {
        this.readAll(this.i16rd, 0, 2);
        return (short)((this.i16rd[0] & 0xFF) << 8 | this.i16rd[1] & 0xFF);
    }

    @Override
    public int readI32() throws TException {
        this.readAll(this.i32rd, 0, 4);
        return (this.i32rd[0] & 0xFF) << 24 | (this.i32rd[1] & 0xFF) << 16 | (this.i32rd[2] & 0xFF) << 8 | this.i32rd[3] & 0xFF;
    }

    @Override
    public long readI64() throws TException {
        this.readAll(this.i64rd, 0, 8);
        return (long)(this.i64rd[0] & 0xFF) << 56 | (long)(this.i64rd[1] & 0xFF) << 48 | (long)(this.i64rd[2] & 0xFF) << 40 | (long)(this.i64rd[3] & 0xFF) << 32 | (long)(this.i64rd[4] & 0xFF) << 24 | (long)(this.i64rd[5] & 0xFF) << 16 | (long)(this.i64rd[6] & 0xFF) << 8 | (long)(this.i64rd[7] & 0xFF);
    }

    @Override
    public double readDouble() throws TException {
        return Double.longBitsToDouble(this.readI64());
    }

    @Override
    public String readString() throws TException {
        int n = this.readI32();
        return this.readStringBody(n);
    }

    public String readStringBody(int n) throws TException {
        try {
            this.checkReadLength(n);
            byte[] byArray = new byte[n];
            this.trans_.readAll(byArray, 0, n);
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public byte[] readBinary() throws TException {
        int n = this.readI32();
        this.checkReadLength(n);
        byte[] byArray = new byte[n];
        this.trans_.readAll(byArray, 0, n);
        return byArray;
    }

    private int readAll(byte[] byArray, int n, int n2) throws TException {
        this.checkReadLength(n2);
        return this.trans_.readAll(byArray, n, n2);
    }

    public void setReadLength(int n) {
        this.readLength_ = n;
        this.checkReadLength_ = true;
    }

    protected void checkReadLength(int n) throws TException {
        if (this.checkReadLength_) {
            this.readLength_ -= n;
            if (this.readLength_ < 0) {
                throw new TException("Message length exceeded: " + n);
            }
        }
    }

    public static class Factory
    implements TProtocolFactory {
        protected boolean strictRead_ = false;
        protected boolean strictWrite_ = true;

        public Factory() {
            this(false, true);
        }

        public Factory(boolean bl, boolean bl2) {
            this.strictRead_ = bl;
            this.strictWrite_ = bl2;
        }

        @Override
        public TProtocol getProtocol(TTransport tTransport) {
            return new TBinaryProtocol(tTransport, this.strictRead_, this.strictWrite_);
        }
    }
}

