/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.transport.TIOStreamTransport;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class TSerializer {
    private final ByteArrayOutputStream baos_ = new ByteArrayOutputStream();
    private final TIOStreamTransport transport_ = new TIOStreamTransport(this.baos_);
    private TProtocol protocol_;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory tProtocolFactory) {
        this.protocol_ = tProtocolFactory.getProtocol(this.transport_);
    }

    public byte[] serialize(TBase tBase) throws TException {
        this.baos_.reset();
        tBase.write(this.protocol_);
        return this.baos_.toByteArray();
    }

    public String toString(TBase tBase, String string) throws TException {
        try {
            return new String(this.serialize(tBase), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + string);
        }
    }

    public String toString(TBase tBase) throws TException {
        return new String(this.serialize(tBase));
    }
}

