/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.compressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorException;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorOutputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.gzip.GzipCompressorInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.gzip.GzipCompressorOutputStream;

public class CompressorStreamFactory {
    public CompressorInputStream createCompressorInputStream(String name, InputStream in) throws CompressorException {
        if (name == null || in == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if ("gz".equalsIgnoreCase(name)) {
                return new GzipCompressorInputStream(in);
            }
            if ("bzip2".equalsIgnoreCase(name)) {
                return new BZip2CompressorInputStream(in);
            }
        }
        catch (IOException e) {
            throw new CompressorException("Could not create CompressorInputStream", e);
        }
        throw new CompressorException("Compressor: " + name + " not found.");
    }

    public CompressorOutputStream createCompressorOutputStream(String name, OutputStream out) throws CompressorException {
        if (name == null || out == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if ("gz".equalsIgnoreCase(name)) {
                return new GzipCompressorOutputStream(out);
            }
            if ("bzip2".equalsIgnoreCase(name)) {
                return new BZip2CompressorOutputStream(out);
            }
        }
        catch (IOException e) {
            throw new CompressorException("Could not create CompressorOutputStream", e);
        }
        throw new CompressorException("Compressor: " + name + " not found.");
    }
}

